/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class StackedContents<T> {
    public final Reference2IntOpenHashMap<T> amounts = new Reference2IntOpenHashMap();

    boolean hasAtLeast(T var0, int var1) {
        return this.amounts.getInt(var0) >= var1;
    }

    void take(T var0, int var1) {
        int var2 = this.amounts.addTo(var0, -var1);
        if (var2 < var1) {
            throw new IllegalStateException("Took " + var1 + " items, but only had " + var2);
        }
    }

    void put(T var0, int var1) {
        this.amounts.addTo(var0, var1);
    }

    public boolean tryPick(List<? extends IngredientInfo<T>> var0, int var1, @Nullable Output<T> var2) {
        return new RecipePicker(var0).tryPick(var1, var2);
    }

    public int tryPickAll(List<? extends IngredientInfo<T>> var0, int var1, @Nullable Output<T> var2) {
        return new RecipePicker(var0).tryPickAll(var1, var2);
    }

    public void clear() {
        this.amounts.clear();
    }

    public void account(T var0, int var1) {
        this.put(var0, var1);
    }

    List<T> getUniqueAvailableIngredientItems(Iterable<? extends IngredientInfo<T>> var0) {
        ArrayList<Object> var1 = new ArrayList<Object>();
        for (Reference2IntMap.Entry var3 : Reference2IntMaps.fastIterable(this.amounts)) {
            if (var3.getIntValue() <= 0 || !StackedContents.anyIngredientMatches(var0, var3.getKey())) continue;
            var1.add(var3.getKey());
        }
        return var1;
    }

    private static <T> boolean anyIngredientMatches(Iterable<? extends IngredientInfo<T>> var0, T var1) {
        for (IngredientInfo<T> var3 : var0) {
            if (!var3.acceptsItem(var1)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public int getResultUpperBound(List<? extends IngredientInfo<T>> var0) {
        int var1 = Integer.MAX_VALUE;
        ObjectIterable var2 = Reference2IntMaps.fastIterable(this.amounts);
        block0: for (IngredientInfo<Object> ingredientInfo : var0) {
            int var5 = 0;
            for (Reference2IntMap.Entry var7 : var2) {
                int var8 = var7.getIntValue();
                if (var8 <= var5) continue;
                if (ingredientInfo.acceptsItem(var7.getKey())) {
                    var5 = var8;
                }
                if (var5 < var1) continue;
                continue block0;
            }
            var1 = var5;
            if (var1 != 0) continue;
            break;
        }
        return var1;
    }

    class RecipePicker {
        private final List<? extends IngredientInfo<T>> ingredients;
        private final int ingredientCount;
        private final List<T> items;
        private final int itemCount;
        private final BitSet data;
        private final IntList path = new IntArrayList();

        public RecipePicker(List var1) {
            this.ingredients = var1;
            this.ingredientCount = var1.size();
            this.items = StackedContents.this.getUniqueAvailableIngredientItems(var1);
            this.itemCount = this.items.size();
            this.data = new BitSet(this.visitedIngredientCount() + this.visitedItemCount() + this.satisfiedCount() + this.connectionCount() + this.residualCount());
            this.setInitialConnections();
        }

        private void setInitialConnections() {
            for (int var0 = 0; var0 < this.ingredientCount; ++var0) {
                IngredientInfo var1 = this.ingredients.get(var0);
                for (int var2 = 0; var2 < this.itemCount; ++var2) {
                    if (!var1.acceptsItem(this.items.get(var2))) continue;
                    this.setConnection(var2, var0);
                }
            }
        }

        public boolean tryPick(int var0, @Nullable Output<T> var1) {
            int var6;
            int var5;
            int var4;
            IntList var3;
            if (var0 <= 0) {
                return true;
            }
            int var2 = 0;
            while ((var3 = this.tryAssigningNewItem(var0)) != null) {
                var4 = var3.getInt(0);
                StackedContents.this.take(this.items.get(var4), var0);
                var5 = var3.size() - 1;
                this.setSatisfied(var3.getInt(var5));
                ++var2;
                for (var6 = 0; var6 < var3.size() - 1; ++var6) {
                    int var8;
                    int var7;
                    if (RecipePicker.isPathIndexItem(var6)) {
                        var7 = var3.getInt(var6);
                        var8 = var3.getInt(var6 + 1);
                        this.assign(var7, var8);
                        continue;
                    }
                    var7 = var3.getInt(var6 + 1);
                    var8 = var3.getInt(var6);
                    this.unassign(var7, var8);
                }
            }
            boolean var9 = var2 == this.ingredientCount;
            var4 = var9 && var1 != null ? 1 : 0;
            this.clearAllVisited();
            this.clearSatisfied();
            block2: for (var5 = 0; var5 < this.ingredientCount; ++var5) {
                for (var6 = 0; var6 < this.itemCount; ++var6) {
                    if (!this.isAssigned(var6, var5)) continue;
                    this.unassign(var6, var5);
                    StackedContents.this.put(this.items.get(var6), var0);
                    if (var4 == 0) continue block2;
                    var1.accept(this.items.get(var6));
                    continue block2;
                }
            }
            assert (this.data.get(this.residualOffset(), this.residualOffset() + this.residualCount()).isEmpty());
            return var9;
        }

        private static boolean isPathIndexItem(int var0) {
            return (var0 & 1) == 0;
        }

        private @Nullable IntList tryAssigningNewItem(int var0) {
            this.clearAllVisited();
            for (int var1 = 0; var1 < this.itemCount; ++var1) {
                IntList var2;
                if (!StackedContents.this.hasAtLeast(this.items.get(var1), var0) || (var2 = this.findNewItemAssignmentPath(var1)) == null) continue;
                return var2;
            }
            return null;
        }

        private @Nullable IntList findNewItemAssignmentPath(int var0) {
            this.path.clear();
            this.visitItem(var0);
            this.path.add(var0);
            while (!this.path.isEmpty()) {
                int var2;
                int var1 = this.path.size();
                if (RecipePicker.isPathIndexItem(var1 - 1)) {
                    var2 = this.path.getInt(var1 - 1);
                    for (var3 = 0; var3 < this.ingredientCount; ++var3) {
                        if (this.hasVisitedIngredient(var3) || !this.hasConnection(var2, var3) || this.isAssigned(var2, var3)) continue;
                        this.visitIngredient(var3);
                        this.path.add(var3);
                        break;
                    }
                } else {
                    var2 = this.path.getInt(var1 - 1);
                    if (!this.isSatisfied(var2)) {
                        return this.path;
                    }
                    for (var3 = 0; var3 < this.itemCount; ++var3) {
                        if (this.hasVisitedItem(var3) || !this.isAssigned(var3, var2)) continue;
                        assert (this.hasConnection(var3, var2));
                        this.visitItem(var3);
                        this.path.add(var3);
                        break;
                    }
                }
                if ((var2 = this.path.size()) != var1) continue;
                this.path.removeInt(var2 - 1);
            }
            return null;
        }

        private int visitedIngredientOffset() {
            return 0;
        }

        private int visitedIngredientCount() {
            return this.ingredientCount;
        }

        private int visitedItemOffset() {
            return this.visitedIngredientOffset() + this.visitedIngredientCount();
        }

        private int visitedItemCount() {
            return this.itemCount;
        }

        private int satisfiedOffset() {
            return this.visitedItemOffset() + this.visitedItemCount();
        }

        private int satisfiedCount() {
            return this.ingredientCount;
        }

        private int connectionOffset() {
            return this.satisfiedOffset() + this.satisfiedCount();
        }

        private int connectionCount() {
            return this.ingredientCount * this.itemCount;
        }

        private int residualOffset() {
            return this.connectionOffset() + this.connectionCount();
        }

        private int residualCount() {
            return this.ingredientCount * this.itemCount;
        }

        private boolean isSatisfied(int var0) {
            return this.data.get(this.getSatisfiedIndex(var0));
        }

        private void setSatisfied(int var0) {
            this.data.set(this.getSatisfiedIndex(var0));
        }

        private int getSatisfiedIndex(int var0) {
            assert (var0 >= 0 && var0 < this.ingredientCount);
            return this.satisfiedOffset() + var0;
        }

        private void clearSatisfied() {
            this.clearRange(this.satisfiedOffset(), this.satisfiedCount());
        }

        private void setConnection(int var0, int var1) {
            this.data.set(this.getConnectionIndex(var0, var1));
        }

        private boolean hasConnection(int var0, int var1) {
            return this.data.get(this.getConnectionIndex(var0, var1));
        }

        private int getConnectionIndex(int var0, int var1) {
            assert (var0 >= 0 && var0 < this.itemCount);
            assert (var1 >= 0 && var1 < this.ingredientCount);
            return this.connectionOffset() + var0 * this.ingredientCount + var1;
        }

        private boolean isAssigned(int var0, int var1) {
            return this.data.get(this.getResidualIndex(var0, var1));
        }

        private void assign(int var0, int var1) {
            int var2 = this.getResidualIndex(var0, var1);
            assert (!this.data.get(var2));
            this.data.set(var2);
        }

        private void unassign(int var0, int var1) {
            int var2 = this.getResidualIndex(var0, var1);
            assert (this.data.get(var2));
            this.data.clear(var2);
        }

        private int getResidualIndex(int var0, int var1) {
            assert (var0 >= 0 && var0 < this.itemCount);
            assert (var1 >= 0 && var1 < this.ingredientCount);
            return this.residualOffset() + var0 * this.ingredientCount + var1;
        }

        private void visitIngredient(int var0) {
            this.data.set(this.getVisitedIngredientIndex(var0));
        }

        private boolean hasVisitedIngredient(int var0) {
            return this.data.get(this.getVisitedIngredientIndex(var0));
        }

        private int getVisitedIngredientIndex(int var0) {
            assert (var0 >= 0 && var0 < this.ingredientCount);
            return this.visitedIngredientOffset() + var0;
        }

        private void visitItem(int var0) {
            this.data.set(this.getVisitiedItemIndex(var0));
        }

        private boolean hasVisitedItem(int var0) {
            return this.data.get(this.getVisitiedItemIndex(var0));
        }

        private int getVisitiedItemIndex(int var0) {
            assert (var0 >= 0 && var0 < this.itemCount);
            return this.visitedItemOffset() + var0;
        }

        private void clearAllVisited() {
            this.clearRange(this.visitedIngredientOffset(), this.visitedIngredientCount());
            this.clearRange(this.visitedItemOffset(), this.visitedItemCount());
        }

        private void clearRange(int var0, int var1) {
            this.data.clear(var0, var0 + var1);
        }

        public int tryPickAll(int var0, @Nullable Output<T> var1) {
            int var4;
            int var2 = 0;
            int var3 = Math.min(var0, StackedContents.this.getResultUpperBound(this.ingredients)) + 1;
            while (true) {
                if (this.tryPick(var4 = (var2 + var3) / 2, null)) {
                    if (var3 - var2 <= 1) break;
                    var2 = var4;
                    continue;
                }
                var3 = var4;
            }
            if (var4 > 0) {
                this.tryPick(var4, var1);
            }
            return var4;
        }
    }

    @FunctionalInterface
    public static interface Output<T> {
        public void accept(T var1);
    }

    @FunctionalInterface
    public static interface IngredientInfo<T> {
        public boolean acceptsItem(T var1);
    }
}

