/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EyeOfEnder
extends Entity
implements ItemSupplier {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;
    private static final float TOO_FAR_SIGNAL_HEIGHT = 8.0f;
    private static final float TOO_FAR_DISTANCE = 12.0f;
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(EyeOfEnder.class, EntityDataSerializers.ITEM_STACK);
    public @Nullable Vec3 target;
    public int life;
    public boolean surviveAfterDeath;

    public EyeOfEnder(EntityType<? extends EyeOfEnder> entitytypes, Level world) {
        super(entitytypes, world);
    }

    public EyeOfEnder(Level world, double d0, double d1, double d2) {
        this((EntityType<? extends EyeOfEnder>)EntityType.EYE_OF_ENDER, world);
        this.setPos(d0, d1, d2);
    }

    public void setItem(ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            this.getEntityData().set(DATA_ITEM_STACK, this.getDefaultItem());
        } else {
            this.getEntityData().set(DATA_ITEM_STACK, itemstack.copyWithCount(1));
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_ITEM_STACK, this.getDefaultItem());
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        if (this.tickCount < 2 && d0 < 12.25) {
            return false;
        }
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    public void signalTo(Vec3 vec3d) {
        Vec3 vec3d1 = vec3d.subtract(this.position());
        double d0 = vec3d1.horizontalDistance();
        this.target = d0 > 12.0 ? this.position().add(vec3d1.x / d0 * 12.0, 8.0, vec3d1.z / d0 * 12.0) : vec3d;
        this.life = 0;
        this.surviveAfterDeath = this.random.nextInt(5) > 0;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 vec3d = this.position().add(this.getDeltaMovement());
        if (!this.level().isClientSide() && this.target != null) {
            this.setDeltaMovement(EyeOfEnder.updateDeltaMovement(this.getDeltaMovement(), vec3d, this.target));
        }
        if (this.level().isClientSide()) {
            Vec3 vec3d1 = vec3d.subtract(this.getDeltaMovement().scale(0.25));
            this.spawnParticles(vec3d1, this.getDeltaMovement());
        }
        this.setPos(vec3d);
        if (!this.level().isClientSide()) {
            ++this.life;
            if (this.life > 80 && !this.level().isClientSide()) {
                this.playSound(SoundEvents.ENDER_EYE_DEATH, 1.0f, 1.0f);
                this.discard(this.surviveAfterDeath ? EntityRemoveEvent.Cause.DROP : EntityRemoveEvent.Cause.DESPAWN);
                if (this.surviveAfterDeath) {
                    this.level().addFreshEntity(new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem()));
                } else {
                    this.level().levelEvent(2003, this.blockPosition(), 0);
                }
            }
        }
    }

    private void spawnParticles(Vec3 vec3d, Vec3 vec3d1) {
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle(ParticleTypes.BUBBLE, vec3d.x, vec3d.y, vec3d.z, vec3d1.x, vec3d1.y, vec3d1.z);
            }
        } else {
            this.level().addParticle(ParticleTypes.PORTAL, vec3d.x + this.random.nextDouble() * 0.6 - 0.3, vec3d.y - 0.5, vec3d.z + this.random.nextDouble() * 0.6 - 0.3, vec3d1.x, vec3d1.y, vec3d1.z);
        }
    }

    private static Vec3 updateDeltaMovement(Vec3 vec3d, Vec3 vec3d1, Vec3 vec3d2) {
        Vec3 vec3d3 = new Vec3(vec3d2.x - vec3d1.x, 0.0, vec3d2.z - vec3d1.z);
        double d0 = vec3d3.length();
        double d1 = Mth.lerp(0.0025, vec3d.horizontalDistance(), d0);
        double d2 = vec3d.y;
        if (d0 < 1.0) {
            d1 *= 0.8;
            d2 *= 0.8;
        }
        double d3 = vec3d1.y - vec3d.y < vec3d2.y ? 1.0 : -1.0;
        return vec3d3.scale(d1 / d0).add(0.0, d2 + (d3 - d2) * 0.015, 0.0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.store("Item", ItemStack.CODEC, this.getItem());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.setItem(valueinput.read("Item", ItemStack.CODEC).orElse(this.getDefaultItem()));
    }

    private ItemStack getDefaultItem() {
        return new ItemStack(Items.ENDER_EYE);
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        return false;
    }
}

