/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.hurtingprojectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class SmallFireball
extends Fireball {
    public SmallFireball(EntityType<? extends SmallFireball> entitytypes, Level world) {
        super((EntityType<? extends Fireball>)entitytypes, world);
    }

    public SmallFireball(Level world, LivingEntity entityliving, Vec3 vec3d) {
        super((EntityType<? extends Fireball>)EntityType.SMALL_FIREBALL, entityliving, vec3d, world);
        if (this.getOwner() != null && this.getOwner() instanceof Mob) {
            ServerLevel worldserver;
            this.isIncendiary = world instanceof ServerLevel && (worldserver = (ServerLevel)world).getGameRules().get(GameRules.MOB_GRIEFING) != false;
        }
    }

    public SmallFireball(Level world, double d0, double d1, double d2, Vec3 vec3d) {
        super((EntityType<? extends Fireball>)EntityType.SMALL_FIREBALL, d0, d1, d2, vec3d, world);
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            DamageSource damagesource;
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = movingobjectpositionentity.getEntity();
            Entity entity1 = this.getOwner();
            int i = entity.getRemainingFireTicks();
            EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)((Projectile)this.getBukkitEntity()), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                entity.igniteForSeconds(event.getDuration(), false);
            }
            if (!entity.hurtServer(worldserver, damagesource = this.damageSources().fireball(this, entity1), 5.0f)) {
                entity.setRemainingFireTicks(i);
            } else {
                EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = this.getOwner();
            if (this.isIncendiary) {
                BlockPos blockposition = movingobjectpositionblock.getBlockPos().relative(movingobjectpositionblock.getDirection());
                if (this.level().isEmptyBlock(blockposition) && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition, this).isCancelled()) {
                    this.level().setBlockAndUpdate(blockposition, BaseFireBlock.getState(this.level(), blockposition));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide()) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

