/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExpBottleEvent;

public class ThrownExperienceBottle
extends ThrowableItemProjectile {
    public ThrownExperienceBottle(EntityType<? extends ThrownExperienceBottle> entitytypes, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)entitytypes, world);
    }

    public ThrownExperienceBottle(Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(EntityType.EXPERIENCE_BOTTLE, entityliving, world, itemstack);
    }

    public ThrownExperienceBottle(Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityType.EXPERIENCE_BOTTLE, d0, d1, d2, world, itemstack);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.EXPERIENCE_BOTTLE;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.07;
    }

    @Override
    protected void onHit(HitResult movingobjectposition) {
        super.onHit(movingobjectposition);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            int i = 3 + worldserver.random.nextInt(5) + worldserver.random.nextInt(5);
            ExpBottleEvent event = CraftEventFactory.callExpBottleEvent(this, movingobjectposition, i);
            i = event.getExperience();
            if (event.getShowEffect()) {
                worldserver.levelEvent(2002, this.blockPosition(), -13083194);
            }
            if (movingobjectposition instanceof BlockHitResult) {
                BlockHitResult movingobjectpositionblock = (BlockHitResult)movingobjectposition;
                Vec3 vec3d = movingobjectpositionblock.getDirection().getUnitVec3();
                ExperienceOrb.awardWithDirection(worldserver, movingobjectposition.getLocation(), vec3d, i);
            } else {
                ExperienceOrb.awardWithDirection(worldserver, movingobjectposition.getLocation(), this.getDeltaMovement().scale(-1.0), i);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

