/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle.minecart;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Minecart
extends AbstractMinecart {
    private float rotationOffset;
    private float playerRotationOffset;

    public Minecart(EntityType<?> var0, Level var1) {
        super(var0, var1);
    }

    @Override
    public InteractionResult interact(Player var0, InteractionHand var1) {
        if (!var0.isSecondaryUseActive() && !this.isVehicle() && (this.level().isClientSide() || var0.startRiding(this))) {
            this.playerRotationOffset = this.rotationOffset;
            if (!this.level().isClientSide()) {
                return var0.startRiding(this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected Item getDropItem() {
        return Items.MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.MINECART);
    }

    @Override
    public void activateMinecart(ServerLevel var0, int var1, int var2, int var3, boolean var4) {
        if (var4) {
            if (this.isVehicle()) {
                this.ejectPassengers();
            }
            if (this.getHurtTime() == 0) {
                this.setHurtDir(-this.getHurtDir());
                this.setHurtTime(10);
                this.setDamage(50.0f);
                this.markHurt();
            }
        }
    }

    @Override
    public boolean isRideable() {
        return true;
    }

    @Override
    public void tick() {
        double var0 = this.getYRot();
        Vec3 var2 = this.position();
        super.tick();
        double var3 = ((double)this.getYRot() - var0) % 360.0;
        if (this.level().isClientSide() && var2.distanceTo(this.position()) > 0.01) {
            this.rotationOffset += (float)var3;
            this.rotationOffset %= 360.0f;
        }
    }

    @Override
    protected void positionRider(Entity var0, Entity.MoveFunction var1) {
        Player var2;
        super.positionRider(var0, var1);
        if (this.level().isClientSide() && var0 instanceof Player && (var2 = (Player)var0).shouldRotateWithMinecart() && Minecart.useExperimentalMovement(this.level())) {
            float var3 = (float)Mth.rotLerp(0.5, (double)this.playerRotationOffset, (double)this.rotationOffset);
            var2.setYRot(var2.getYRot() - (var3 - this.playerRotationOffset));
            this.playerRotationOffset = var3;
        }
    }
}

