/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.Identifier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.slf4j.Logger;

public class FeatureFlagRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final FeatureFlagUniverse universe;
    public final Map<Identifier, FeatureFlag> names;
    private final FeatureFlagSet allFlags;

    FeatureFlagRegistry(FeatureFlagUniverse var0, FeatureFlagSet var1, Map<Identifier, FeatureFlag> var2) {
        this.universe = var0;
        this.names = var2;
        this.allFlags = var1;
    }

    public boolean isSubset(FeatureFlagSet var0) {
        return var0.isSubsetOf(this.allFlags);
    }

    public FeatureFlagSet allFlags() {
        return this.allFlags;
    }

    public FeatureFlagSet fromNames(Iterable<Identifier> var02) {
        return this.fromNames(var02, var0 -> LOGGER.warn("Unknown feature flag: {}", var0));
    }

    public FeatureFlagSet subset(FeatureFlag ... var0) {
        return FeatureFlagSet.create(this.universe, Arrays.asList(var0));
    }

    public FeatureFlagSet fromNames(Iterable<Identifier> var0, Consumer<Identifier> var1) {
        Set var2 = Sets.newIdentityHashSet();
        for (Identifier var4 : var0) {
            FeatureFlag var5 = this.names.get(var4);
            if (var5 == null) {
                var1.accept(var4);
                continue;
            }
            var2.add(var5);
        }
        return FeatureFlagSet.create(this.universe, var2);
    }

    public Set<Identifier> toNames(FeatureFlagSet var0) {
        HashSet<Identifier> var1 = new HashSet<Identifier>();
        this.names.forEach((var2, var3) -> {
            if (var0.contains((FeatureFlag)var3)) {
                var1.add((Identifier)var2);
            }
        });
        return var1;
    }

    public Codec<FeatureFlagSet> codec() {
        return Identifier.CODEC.listOf().comapFlatMap(var0 -> {
            HashSet var1 = new HashSet();
            FeatureFlagSet var2 = this.fromNames((Iterable<Identifier>)var0, var1::add);
            if (!var1.isEmpty()) {
                return DataResult.error(() -> "Unknown feature ids: " + String.valueOf(var1), (Object)var2);
            }
            return DataResult.success((Object)var2);
        }, var0 -> List.copyOf(this.toNames((FeatureFlagSet)var0)));
    }

    public static class Builder {
        private final FeatureFlagUniverse universe;
        private int id;
        private final Map<Identifier, FeatureFlag> flags = new LinkedHashMap<Identifier, FeatureFlag>();

        public Builder(String var0) {
            this.universe = new FeatureFlagUniverse(var0);
        }

        public FeatureFlag createVanilla(String var0) {
            return this.create(Identifier.withDefaultNamespace(var0));
        }

        public FeatureFlag create(Identifier var0) {
            FeatureFlag var1;
            FeatureFlag var2;
            if (this.id >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if ((var2 = this.flags.put(var0, var1 = new FeatureFlag(this.universe, this.id++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + String.valueOf(var0));
            }
            return var1;
        }

        public FeatureFlagRegistry build() {
            FeatureFlagSet var0 = FeatureFlagSet.create(this.universe, this.flags.values());
            return new FeatureFlagRegistry(this.universe, var0, Map.copyOf(this.flags));
        }
    }
}

