/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodData {
    private static final int DEFAULT_TICK_TIMER = 0;
    private static final float DEFAULT_EXHAUSTION_LEVEL = 0.0f;
    public int foodLevel = 20;
    public float saturationLevel = 5.0f;
    public float exhaustionLevel;
    private int tickTimer;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;

    private void add(int i, float f) {
        this.foodLevel = Mth.clamp(i + this.foodLevel, 0, 20);
        this.saturationLevel = Mth.clamp(f + this.saturationLevel, 0.0f, (float)this.foodLevel);
    }

    public void eat(int i, float f) {
        this.add(i, FoodConstants.saturationByModifier(i, f));
    }

    public void eat(FoodProperties foodinfo) {
        this.add(foodinfo.nutrition(), foodinfo.saturation());
    }

    public void eat(FoodProperties foodinfo, ItemStack itemstack, ServerPlayer entityplayer) {
        int oldFoodLevel = this.foodLevel;
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityplayer, foodinfo.nutrition() + oldFoodLevel, itemstack);
        if (!event.isCancelled()) {
            this.add(event.getFoodLevel() - oldFoodLevel, foodinfo.saturation());
        }
        entityplayer.getBukkitEntity().sendHealthUpdate();
    }

    public void tick(ServerPlayer entityplayer) {
        boolean flag;
        ServerLevel worldserver = entityplayer.level();
        Difficulty enumdifficulty = worldserver.getDifficulty();
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (enumdifficulty != Difficulty.PEACEFUL) {
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityplayer, Math.max(this.foodLevel - 1, 0));
                if (!event.isCancelled()) {
                    this.foodLevel = event.getFoodLevel();
                }
                entityplayer.connection.send(new ClientboundSetHealthPacket(entityplayer.getBukkitEntity().getScaledHealth(), this.foodLevel, this.saturationLevel));
            }
        }
        if ((flag = worldserver.getGameRules().get(GameRules.NATURAL_HEALTH_REGENERATION).booleanValue()) && this.saturationLevel > 0.0f && entityplayer.isHurt() && this.foodLevel >= 20) {
            ++this.tickTimer;
            if (this.tickTimer >= this.saturatedRegenRate) {
                float f = Math.min(this.saturationLevel, 6.0f);
                entityplayer.heal(f / 6.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                entityplayer.causeFoodExhaustion(f, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.tickTimer = 0;
            }
        } else if (flag && this.foodLevel >= 18 && entityplayer.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= this.unsaturatedRegenRate) {
                entityplayer.heal(1.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                entityplayer.causeFoodExhaustion(entityplayer.level().spigotConfig.regenExhaustion, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= this.starvationRate) {
                if (entityplayer.getHealth() > 10.0f || enumdifficulty == Difficulty.HARD || entityplayer.getHealth() > 1.0f && enumdifficulty == Difficulty.NORMAL) {
                    entityplayer.hurtServer(worldserver, entityplayer.damageSources().starve(), 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
    }

    public void readAdditionalSaveData(ValueInput valueinput) {
        this.foodLevel = valueinput.getIntOr("foodLevel", 20);
        this.tickTimer = valueinput.getIntOr("foodTickTimer", 0);
        this.saturationLevel = valueinput.getFloatOr("foodSaturationLevel", 5.0f);
        this.exhaustionLevel = valueinput.getFloatOr("foodExhaustionLevel", 0.0f);
    }

    public void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.putInt("foodLevel", this.foodLevel);
        valueoutput.putInt("foodTickTimer", this.tickTimer);
        valueoutput.putFloat("foodSaturationLevel", this.saturationLevel);
        valueoutput.putFloat("foodExhaustionLevel", this.exhaustionLevel);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public boolean hasEnoughFood() {
        return (float)this.getFoodLevel() > 6.0f;
    }

    public boolean needsFood() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float f) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + f, 40.0f);
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public void setFoodLevel(int i) {
        this.foodLevel = i;
    }

    public void setSaturation(float f) {
        this.saturationLevel = f;
    }
}

