/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;

public class ChestMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;
    private CraftInventoryView bukkitEntity = null;
    private Inventory player;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventory inventory = this.container instanceof Inventory ? new CraftInventoryPlayer((Inventory)this.container) : (this.container instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)this.container) : new CraftInventory(this.container));
        this.bukkitEntity = new CraftInventoryView<ChestMenu, CraftInventoryPlayer>(this.player.player.getBukkitEntity(), (CraftInventoryPlayer)inventory, this);
        return this.bukkitEntity;
    }

    @Override
    public void startOpen() {
        super.startOpen();
        this.container.startOpen(this.player.player);
    }

    private ChestMenu(MenuType<?> containers, int i, Inventory playerinventory, int j) {
        this(containers, i, playerinventory, new SimpleContainer(9 * j), j);
    }

    public static ChestMenu oneRow(int i, Inventory playerinventory) {
        return new ChestMenu(MenuType.GENERIC_9x1, i, playerinventory, 1);
    }

    public static ChestMenu twoRows(int i, Inventory playerinventory) {
        return new ChestMenu(MenuType.GENERIC_9x2, i, playerinventory, 2);
    }

    public static ChestMenu threeRows(int i, Inventory playerinventory) {
        return new ChestMenu(MenuType.GENERIC_9x3, i, playerinventory, 3);
    }

    public static ChestMenu fourRows(int i, Inventory playerinventory) {
        return new ChestMenu(MenuType.GENERIC_9x4, i, playerinventory, 4);
    }

    public static ChestMenu fiveRows(int i, Inventory playerinventory) {
        return new ChestMenu(MenuType.GENERIC_9x5, i, playerinventory, 5);
    }

    public static ChestMenu sixRows(int i, Inventory playerinventory) {
        return new ChestMenu(MenuType.GENERIC_9x6, i, playerinventory, 6);
    }

    public static ChestMenu threeRows(int i, Inventory playerinventory, Container iinventory) {
        return new ChestMenu(MenuType.GENERIC_9x3, i, playerinventory, iinventory, 3);
    }

    public static ChestMenu sixRows(int i, Inventory playerinventory, Container iinventory) {
        return new ChestMenu(MenuType.GENERIC_9x6, i, playerinventory, iinventory, 6);
    }

    public ChestMenu(MenuType<?> containers, int i, Inventory playerinventory, Container iinventory, int j) {
        super(containers, i);
        ChestMenu.checkContainerSize(iinventory, j * 9);
        this.container = iinventory;
        this.containerRows = j;
        this.player = playerinventory;
        int k = 18;
        this.addChestGrid(iinventory, 8, 18);
        int l = 18 + this.containerRows * 18 + 13;
        this.addStandardInventorySlots(playerinventory, 8, l);
    }

    private void addChestGrid(Container iinventory, int i, int j) {
        for (int k = 0; k < this.containerRows; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot(iinventory, l + k * 9, i + l * 18, j + k * 18));
            }
        }
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i < this.containerRows * 9 ? !this.moveItemStackTo(itemstack1, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.container.stopOpen(entityhuman);
    }

    public Container getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }
}

