/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.World;

public interface ContainerLevelAccess {
    public static final ContainerLevelAccess NULL = new ContainerLevelAccess(){

        @Override
        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> bifunction) {
            return Optional.empty();
        }
    };

    default public Level getWorld() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public BlockPos getPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public Location getLocation() {
        return new Location((World)this.getWorld().getWorld(), (double)this.getPosition().getX(), (double)this.getPosition().getY(), (double)this.getPosition().getZ());
    }

    public static ContainerLevelAccess create(final Level world, final BlockPos blockposition) {
        return new ContainerLevelAccess(){

            @Override
            public Level getWorld() {
                return world;
            }

            @Override
            public BlockPos getPosition() {
                return blockposition;
            }

            @Override
            public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> bifunction) {
                return Optional.of(bifunction.apply(world, blockposition));
            }
        };
    }

    public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> var1);

    default public <T> T evaluate(BiFunction<Level, BlockPos, T> bifunction, T t0) {
        return this.evaluate(bifunction).orElse(t0);
    }

    default public void execute(BiConsumer<Level, BlockPos> biconsumer) {
        this.evaluate((world, blockposition) -> {
            biconsumer.accept((Level)world, (BlockPos)blockposition);
            return Optional.empty();
        });
    }
}

