/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;

public class GrindstoneMenu
extends AbstractContainerMenu {
    private CraftInventoryView bukkitEntity = null;
    private org.bukkit.entity.Player player;
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Container resultSlots = new ResultContainer();
    final Container repairSlots;
    private final ContainerLevelAccess access;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryGrindstone inventory = new CraftInventoryGrindstone(this.repairSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<GrindstoneMenu, CraftInventoryGrindstone>((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public GrindstoneMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, ContainerLevelAccess.NULL);
    }

    public GrindstoneMenu(int i, Inventory playerinventory, final ContainerLevelAccess containeraccess) {
        super(MenuType.GRINDSTONE, i);
        this.repairSlots = new SimpleContainer(2){

            @Override
            public void setChanged() {
                super.setChanged();
                GrindstoneMenu.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.access = containeraccess;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(itemstack);
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(itemstack);
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public void onTake(Player entityhuman, ItemStack itemstack) {
                containeraccess.execute((world, blockposition) -> {
                    if (world instanceof ServerLevel) {
                        ExperienceOrb.award((ServerLevel)world, Vec3.atCenterOf(blockposition), this.getExperienceAmount((Level)world));
                    }
                    world.levelEvent(1042, (BlockPos)blockposition, 0);
                });
                GrindstoneMenu.this.repairSlots.setItem(0, ItemStack.EMPTY);
                GrindstoneMenu.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(Level world) {
                int j = 0;
                j += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(0));
                if ((j += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(1))) > 0) {
                    int k = (int)Math.ceil((double)j / 2.0);
                    return k + world.random.nextInt(k);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack itemstack) {
                int j = 0;
                ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(itemstack);
                for (Object2IntMap.Entry<Holder<Enchantment>> object2intmap_entry : itemenchantments.entrySet()) {
                    Holder holder = (Holder)object2intmap_entry.getKey();
                    int k = object2intmap_entry.getIntValue();
                    if (holder.is(EnchantmentTags.CURSE)) continue;
                    j += ((Enchantment)holder.value()).getMinCost(k);
                }
                return j;
            }
        });
        this.addStandardInventorySlots(playerinventory, 8, 84);
        this.player = (org.bukkit.entity.Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(Container iinventory) {
        super.slotsChanged(iinventory);
        if (iinventory == this.repairSlots) {
            this.createResult();
        }
    }

    private void createResult() {
        CraftEventFactory.callPrepareGrindstoneEvent(this.getBukkitView(), this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        this.sendAllDataToRemote();
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack itemstack, ItemStack itemstack1) {
        boolean flag;
        boolean bl = flag = !itemstack.isEmpty() || !itemstack1.isEmpty();
        if (!flag) {
            return ItemStack.EMPTY;
        }
        if (itemstack.getCount() <= 1 && itemstack1.getCount() <= 1) {
            boolean flag1;
            boolean bl2 = flag1 = !itemstack.isEmpty() && !itemstack1.isEmpty();
            if (!flag1) {
                ItemStack itemstack2 = !itemstack.isEmpty() ? itemstack : itemstack1;
                return !EnchantmentHelper.hasAnyEnchantments(itemstack2) ? ItemStack.EMPTY : this.removeNonCursesFrom(itemstack2.copy());
            }
            return this.mergeItems(itemstack, itemstack1);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack mergeItems(ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2;
        if (!itemstack.is(itemstack1.getItem())) {
            return ItemStack.EMPTY;
        }
        int i = Math.max(itemstack.getMaxDamage(), itemstack1.getMaxDamage());
        int j = itemstack.getMaxDamage() - itemstack.getDamageValue();
        int k = itemstack1.getMaxDamage() - itemstack1.getDamageValue();
        int l = j + k + i * 5 / 100;
        int i1 = 1;
        if (!itemstack.isDamageableItem()) {
            if (itemstack.getMaxStackSize() < 2 || !ItemStack.matches(itemstack, itemstack1)) {
                return ItemStack.EMPTY;
            }
            i1 = 2;
        }
        if ((itemstack2 = itemstack.copyWithCount(i1)).isDamageableItem()) {
            itemstack2.set(DataComponents.MAX_DAMAGE, i);
            itemstack2.setDamageValue(Math.max(i - l, 0));
        }
        this.mergeEnchantsFrom(itemstack2, itemstack1);
        return this.removeNonCursesFrom(itemstack2);
    }

    private void mergeEnchantsFrom(ItemStack itemstack, ItemStack itemstack1) {
        EnchantmentHelper.updateEnchantments(itemstack, itemenchantments_a -> {
            ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(itemstack1);
            for (Object2IntMap.Entry<Holder<Enchantment>> object2intmap_entry : itemenchantments.entrySet()) {
                Holder holder = (Holder)object2intmap_entry.getKey();
                if (holder.is(EnchantmentTags.CURSE) && itemenchantments_a.getLevel(holder) != 0) continue;
                itemenchantments_a.upgrade(holder, object2intmap_entry.getIntValue());
            }
        });
    }

    private ItemStack removeNonCursesFrom(ItemStack itemstack) {
        ItemEnchantments itemenchantments = EnchantmentHelper.updateEnchantments(itemstack, itemenchantments_a -> itemenchantments_a.removeIf(holder -> !holder.is(EnchantmentTags.CURSE)));
        if (itemstack.is(Items.ENCHANTED_BOOK) && itemenchantments.isEmpty()) {
            itemstack = itemstack.transmuteCopy(Items.BOOK);
        }
        int i = 0;
        for (int j = 0; j < itemenchantments.size(); ++j) {
            i = AnvilMenu.calculateIncreasedRepairCost(i);
        }
        itemstack.set(DataComponents.REPAIR_COST, i);
        return itemstack;
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.repairSlots));
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return GrindstoneMenu.stillValid(this.access, entityhuman, Blocks.GRINDSTONE);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            ItemStack itemstack2 = this.repairSlots.getItem(0);
            ItemStack itemstack3 = this.repairSlots.getItem(1);
            if (i == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i != 0 && i != 1 ? (!itemstack2.isEmpty() && !itemstack3.isEmpty() ? (i >= 3 && i < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i >= 30 && i < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 0, 2, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }
}

