/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.resources.Identifier;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractMountInventoryMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;

public class HorseInventoryMenu
extends AbstractMountInventoryMenu {
    private static final Identifier SADDLE_SLOT_SPRITE = Identifier.withDefaultNamespace("container/slot/saddle");
    private static final Identifier LLAMA_ARMOR_SLOT_SPRITE = Identifier.withDefaultNamespace("container/slot/llama_armor");
    private static final Identifier ARMOR_SLOT_SPRITE = Identifier.withDefaultNamespace("container/slot/horse_armor");

    public HorseInventoryMenu(int var0, Inventory var1, Container var2, final AbstractHorse var3, int var4) {
        super(var0, var1, var2, var3);
        Container var5 = var3.createEquipmentSlotContainer(EquipmentSlot.SADDLE);
        this.addSlot(new ArmorSlot(this, var5, var3, EquipmentSlot.SADDLE, 0, 8, 18, SADDLE_SLOT_SPRITE){

            @Override
            public boolean isActive() {
                return var3.canUseSlot(EquipmentSlot.SADDLE) && var3.getType().is(EntityTypeTags.CAN_EQUIP_SADDLE);
            }
        });
        final boolean var6 = var3 instanceof Llama;
        Identifier var7 = var6 ? LLAMA_ARMOR_SLOT_SPRITE : ARMOR_SLOT_SPRITE;
        Container var8 = var3.createEquipmentSlotContainer(EquipmentSlot.BODY);
        this.addSlot(new ArmorSlot(this, var8, var3, EquipmentSlot.BODY, 0, 8, 36, var7){

            @Override
            public boolean isActive() {
                return var3.canUseSlot(EquipmentSlot.BODY) && (var3.getType().is(EntityTypeTags.CAN_WEAR_HORSE_ARMOR) || var6);
            }
        });
        if (var4 > 0) {
            for (int var9 = 0; var9 < 3; ++var9) {
                for (int var10 = 0; var10 < var4; ++var10) {
                    this.addSlot(new Slot(var2, var10 + var9 * var4, 80 + var10 * 18, 18 + var9 * 18));
                }
            }
        }
        this.addStandardInventorySlots(var1, 8, 84);
    }

    @Override
    protected boolean hasInventoryChanged(Container var0) {
        return ((AbstractHorse)this.mount).hasInventoryChanged(var0);
    }
}

