/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.npc.villager.AbstractVillager;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public class MerchantContainer
implements Container {
    private final Merchant merchant;
    private final NonNullList<ItemStack> itemStacks;
    private @Nullable MerchantOffer activeOffer;
    public int selectionHint;
    private int futureXp;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.itemStacks;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
        this.merchant.setTradingPlayer(null);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i) {
        this.maxStack = i;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.merchant instanceof AbstractVillager ? (CraftAbstractVillager)((AbstractVillager)this.merchant).getBukkitEntity() : null;
    }

    @Override
    public Location getLocation() {
        return this.merchant instanceof Villager ? ((Villager)this.merchant).getBukkitEntity().getLocation() : null;
    }

    public MerchantContainer(Merchant imerchant) {
        this.itemStacks = NonNullList.withSize(3, ItemStack.EMPTY);
        this.merchant = imerchant;
    }

    @Override
    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int i) {
        return this.itemStacks.get(i);
    }

    @Override
    public ItemStack removeItem(int i, int j) {
        ItemStack itemstack = this.itemStacks.get(i);
        if (i == 2 && !itemstack.isEmpty()) {
            return ContainerHelper.removeItem(this.itemStacks, i, itemstack.getCount());
        }
        ItemStack itemstack1 = ContainerHelper.removeItem(this.itemStacks, i, j);
        if (!itemstack1.isEmpty() && this.isPaymentSlot(i)) {
            this.updateSellItem();
        }
        return itemstack1;
    }

    private boolean isPaymentSlot(int i) {
        return i == 0 || i == 1;
    }

    @Override
    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.itemStacks, i);
    }

    @Override
    public void setItem(int i, ItemStack itemstack) {
        this.itemStacks.set(i, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
        if (this.isPaymentSlot(i)) {
            this.updateSellItem();
        }
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        return this.merchant.getTradingPlayer() == entityhuman;
    }

    @Override
    public void setChanged() {
        this.updateSellItem();
    }

    public void updateSellItem() {
        ItemStack itemstack1;
        ItemStack itemstack;
        this.activeOffer = null;
        if (this.itemStacks.get(0).isEmpty()) {
            itemstack = this.itemStacks.get(1);
            itemstack1 = ItemStack.EMPTY;
        } else {
            itemstack = this.itemStacks.get(0);
            itemstack1 = this.itemStacks.get(1);
        }
        if (itemstack.isEmpty()) {
            this.setItem(2, ItemStack.EMPTY);
            this.futureXp = 0;
        } else {
            MerchantOffers merchantrecipelist = this.merchant.getOffers();
            if (!merchantrecipelist.isEmpty()) {
                MerchantOffer merchantrecipe = merchantrecipelist.getRecipeFor(itemstack, itemstack1, this.selectionHint);
                if (merchantrecipe == null || merchantrecipe.isOutOfStock()) {
                    this.activeOffer = merchantrecipe;
                    merchantrecipe = merchantrecipelist.getRecipeFor(itemstack1, itemstack, this.selectionHint);
                }
                if (merchantrecipe != null && !merchantrecipe.isOutOfStock()) {
                    this.activeOffer = merchantrecipe;
                    this.setItem(2, merchantrecipe.assemble());
                    this.futureXp = merchantrecipe.getXp();
                } else {
                    this.setItem(2, ItemStack.EMPTY);
                    this.futureXp = 0;
                }
            }
            this.merchant.notifyTradeUpdated(this.getItem(2));
        }
    }

    public @Nullable MerchantOffer getActiveOffer() {
        return this.activeOffer;
    }

    public void setSelectionHint(int i) {
        this.selectionHint = i;
        this.updateSellItem();
    }

    @Override
    public void clearContent() {
        this.itemStacks.clear();
    }

    public int getFutureXp() {
        return this.futureXp;
    }
}

