/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jspecify.annotations.Nullable;

public class AxeItem
extends Item {
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.OAK_WOOD, (Object)Blocks.STRIPPED_OAK_WOOD).put((Object)Blocks.OAK_LOG, (Object)Blocks.STRIPPED_OAK_LOG).put((Object)Blocks.DARK_OAK_WOOD, (Object)Blocks.STRIPPED_DARK_OAK_WOOD).put((Object)Blocks.DARK_OAK_LOG, (Object)Blocks.STRIPPED_DARK_OAK_LOG).put((Object)Blocks.PALE_OAK_WOOD, (Object)Blocks.STRIPPED_PALE_OAK_WOOD).put((Object)Blocks.PALE_OAK_LOG, (Object)Blocks.STRIPPED_PALE_OAK_LOG).put((Object)Blocks.ACACIA_WOOD, (Object)Blocks.STRIPPED_ACACIA_WOOD).put((Object)Blocks.ACACIA_LOG, (Object)Blocks.STRIPPED_ACACIA_LOG).put((Object)Blocks.CHERRY_WOOD, (Object)Blocks.STRIPPED_CHERRY_WOOD).put((Object)Blocks.CHERRY_LOG, (Object)Blocks.STRIPPED_CHERRY_LOG).put((Object)Blocks.BIRCH_WOOD, (Object)Blocks.STRIPPED_BIRCH_WOOD).put((Object)Blocks.BIRCH_LOG, (Object)Blocks.STRIPPED_BIRCH_LOG).put((Object)Blocks.JUNGLE_WOOD, (Object)Blocks.STRIPPED_JUNGLE_WOOD).put((Object)Blocks.JUNGLE_LOG, (Object)Blocks.STRIPPED_JUNGLE_LOG).put((Object)Blocks.SPRUCE_WOOD, (Object)Blocks.STRIPPED_SPRUCE_WOOD).put((Object)Blocks.SPRUCE_LOG, (Object)Blocks.STRIPPED_SPRUCE_LOG).put((Object)Blocks.WARPED_STEM, (Object)Blocks.STRIPPED_WARPED_STEM).put((Object)Blocks.WARPED_HYPHAE, (Object)Blocks.STRIPPED_WARPED_HYPHAE).put((Object)Blocks.CRIMSON_STEM, (Object)Blocks.STRIPPED_CRIMSON_STEM).put((Object)Blocks.CRIMSON_HYPHAE, (Object)Blocks.STRIPPED_CRIMSON_HYPHAE).put((Object)Blocks.MANGROVE_WOOD, (Object)Blocks.STRIPPED_MANGROVE_WOOD).put((Object)Blocks.MANGROVE_LOG, (Object)Blocks.STRIPPED_MANGROVE_LOG).put((Object)Blocks.BAMBOO_BLOCK, (Object)Blocks.STRIPPED_BAMBOO_BLOCK).build();

    public AxeItem(ToolMaterial var0, float var1, float var2, Item.Properties var3) {
        super(var3.axe(var0, var1, var2));
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        Player var3 = var0.getPlayer();
        if (AxeItem.playerHasBlockingItemUseIntent(var0)) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> var4 = this.evaluateNewBlockState(var1, var2, var3, var1.getBlockState(var2));
        if (var4.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack var5 = var0.getItemInHand();
        if (var3 instanceof ServerPlayer) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)var3, var2, var5);
        }
        var1.setBlock(var2, var4.get(), 11);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.Context.of(var3, var4.get()));
        if (var3 != null) {
            var5.hurtAndBreak(1, (LivingEntity)var3, var0.getHand().asEquipmentSlot());
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean playerHasBlockingItemUseIntent(UseOnContext var0) {
        Player var1 = var0.getPlayer();
        return var0.getHand().equals((Object)InteractionHand.MAIN_HAND) && var1.getOffhandItem().has(DataComponents.BLOCKS_ATTACKS) && !var1.isSecondaryUseActive();
    }

    private Optional<BlockState> evaluateNewBlockState(Level var0, BlockPos var12, @Nullable Player var2, BlockState var3) {
        Optional<BlockState> var4 = this.getStripped(var3);
        if (var4.isPresent()) {
            var0.playSound((Entity)var2, var12, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return var4;
        }
        Optional<BlockState> var5 = WeatheringCopper.getPrevious(var3);
        if (var5.isPresent()) {
            AxeItem.spawnSoundAndParticle(var0, var12, var2, var3, SoundEvents.AXE_SCRAPE, 3005);
            return var5;
        }
        Optional<BlockState> var6 = Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)var3.getBlock())).map(var1 -> var1.withPropertiesOf(var3));
        if (var6.isPresent()) {
            AxeItem.spawnSoundAndParticle(var0, var12, var2, var3, SoundEvents.AXE_WAX_OFF, 3004);
            return var6;
        }
        return Optional.empty();
    }

    private static void spawnSoundAndParticle(Level var0, BlockPos var1, @Nullable Player var2, BlockState var3, SoundEvent var4, int var5) {
        var0.playSound((Entity)var2, var1, var4, SoundSource.BLOCKS, 1.0f, 1.0f);
        var0.levelEvent(var2, var5, var1, 0);
        if (var3.getBlock() instanceof ChestBlock && var3.getValue(ChestBlock.TYPE) != ChestType.SINGLE) {
            BlockPos var6 = ChestBlock.getConnectedBlockPos(var1, var3);
            var0.gameEvent(GameEvent.BLOCK_CHANGE, var6, GameEvent.Context.of(var2, var0.getBlockState(var6)));
            var0.levelEvent(var2, var5, var6, 0);
        }
    }

    private Optional<BlockState> getStripped(BlockState var0) {
        return Optional.ofNullable(STRIPPABLES.get(var0.getBlock())).map(var1 -> (BlockState)var1.defaultBlockState().setValue(RotatedPillarBlock.AXIS, var0.getValue(RotatedPillarBlock.AXIS)));
    }
}

