/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class BowItem
extends ProjectileWeaponItem {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 15;

    public BowItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public boolean releaseUsing(ItemStack var0, Level var1, LivingEntity var2, int var3) {
        if (!(var2 instanceof Player)) {
            return false;
        }
        Player var4 = (Player)var2;
        ItemStack var5 = var4.getProjectile(var0);
        if (var5.isEmpty()) {
            return false;
        }
        int var6 = this.getUseDuration(var0, var2) - var3;
        float var7 = BowItem.getPowerForTime(var6);
        if ((double)var7 < 0.1) {
            return false;
        }
        List<ItemStack> var8 = BowItem.draw(var0, var5, var4);
        if (var1 instanceof ServerLevel) {
            ServerLevel var9 = (ServerLevel)var1;
            if (!var8.isEmpty()) {
                this.shoot(var9, var4, var4.getUsedItemHand(), var0, var8, var7 * 3.0f, 1.0f, var7 == 1.0f, null);
            }
        }
        var1.playSound(null, var4.getX(), var4.getY(), var4.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (var1.getRandom().nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
        var4.awardStat(Stats.ITEM_USED.get(this));
        return true;
    }

    @Override
    protected void shootProjectile(LivingEntity var0, Projectile var1, int var2, float var3, float var4, float var5, @Nullable LivingEntity var6) {
        var1.shootFromRotation(var0, var0.getXRot(), var0.getYRot() + var5, 0.0f, var3, var4);
    }

    public static float getPowerForTime(int var0) {
        float var1 = (float)var0 / 20.0f;
        if ((var1 = (var1 * var1 + var1 * 2.0f) / 3.0f) > 1.0f) {
            var1 = 1.0f;
        }
        return var1;
    }

    @Override
    public int getUseDuration(ItemStack var0, LivingEntity var1) {
        return 72000;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.BOW;
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        boolean var4;
        ItemStack var3 = var1.getItemInHand(var2);
        boolean bl = var4 = !var1.getProjectile(var3).isEmpty();
        if (var1.hasInfiniteMaterials() || var4) {
            var1.startUsingItem(var2);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public int getDefaultProjectileRange() {
        return 15;
    }
}

