/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.hurtingprojectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.block.BlockIgniteEvent;

public class FireChargeItem
extends Item
implements ProjectileItem {
    public FireChargeItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        Level world = itemactioncontext.getLevel();
        BlockPos blockposition = itemactioncontext.getClickedPos();
        BlockState iblockdata = world.getBlockState(blockposition);
        boolean flag = false;
        if (!(CampfireBlock.canLight(iblockdata) || CandleBlock.canLight(iblockdata) || CandleCakeBlock.canLight(iblockdata))) {
            if (BaseFireBlock.canBePlacedAt(world, blockposition = blockposition.relative(itemactioncontext.getClickedFace()), itemactioncontext.getHorizontalDirection())) {
                if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, BlockIgniteEvent.IgniteCause.FIREBALL, itemactioncontext.getPlayer()).isCancelled()) {
                    if (!itemactioncontext.getPlayer().getAbilities().instabuild) {
                        itemactioncontext.getItemInHand().shrink(1);
                    }
                    return InteractionResult.PASS;
                }
                this.playSound(world, blockposition);
                world.setBlockAndUpdate(blockposition, BaseFireBlock.getState(world, blockposition));
                world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.BLOCK_PLACE, blockposition);
                flag = true;
            }
        } else {
            if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, BlockIgniteEvent.IgniteCause.FIREBALL, itemactioncontext.getPlayer()).isCancelled()) {
                if (!itemactioncontext.getPlayer().getAbilities().instabuild) {
                    itemactioncontext.getItemInHand().shrink(1);
                }
                return InteractionResult.PASS;
            }
            this.playSound(world, blockposition);
            world.setBlockAndUpdate(blockposition, (BlockState)iblockdata.setValue(BlockStateProperties.LIT, true));
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.BLOCK_CHANGE, blockposition);
            flag = true;
        }
        if (flag) {
            itemactioncontext.getItemInHand().shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void playSound(Level world, BlockPos blockposition) {
        RandomSource randomsource = world.getRandom();
        world.playSound((Entity)null, blockposition, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public Projectile asProjectile(Level world, Position iposition, ItemStack itemstack, Direction enumdirection) {
        RandomSource randomsource = world.getRandom();
        double d0 = randomsource.triangle((double)enumdirection.getStepX(), 0.11485000000000001);
        double d1 = randomsource.triangle((double)enumdirection.getStepY(), 0.11485000000000001);
        double d2 = randomsource.triangle((double)enumdirection.getStepZ(), 0.11485000000000001);
        Vec3 vec3d = new Vec3(d0, d1, d2);
        SmallFireball entitysmallfireball = new SmallFireball(world, iposition.x(), iposition.y(), iposition.z(), vec3d.normalize());
        entitysmallfireball.setItem(itemstack);
        return entitysmallfireball;
    }

    @Override
    public void shoot(Projectile iprojectile, double d0, double d1, double d2, float f, float f1) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((sourceblock, enumdirection) -> DispenserBlock.getDispensePosition(sourceblock, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1018).build();
    }
}

