/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class LeadItem
extends Item {
    public LeadItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        BlockPos blockposition;
        Level world = itemactioncontext.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (iblockdata.is(BlockTags.FENCES)) {
            Player entityhuman = itemactioncontext.getPlayer();
            if (!world.isClientSide() && entityhuman != null) {
                return LeadItem.bindPlayerMobs(entityhuman, world, blockposition, itemactioncontext.getHand());
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player entityhuman, Level world, BlockPos blockposition, InteractionHand enumhand) {
        Entity entityleash = null;
        List<Leashable> list = Leashable.leashableInArea(world, Vec3.atCenterOf(blockposition), leashable -> leashable.getLeashHolder() == entityhuman);
        boolean flag = false;
        Iterator<Leashable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Entity leashed;
            Leashable leashable2 = iterator.next();
            if (entityleash == null) {
                entityleash = LeashFenceKnotEntity.getOrCreateKnot(world, blockposition);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)entityleash.getBukkitEntity(), entityhuman != null ? (org.bukkit.entity.Player)entityhuman.getBukkitEntity() : null, (Block)CraftBlock.at(world, blockposition), BlockFace.SELF, hand);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    entityleash.discard(null);
                    return InteractionResult.PASS;
                }
                ((LeashFenceKnotEntity)entityleash).playPlacementSound();
            }
            if (!leashable2.canHaveALeashAttachedTo(entityleash)) continue;
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), entityleash, entityhuman, enumhand).isCancelled()) {
                iterator.remove();
                continue;
            }
            leashable2.setLeashedTo(entityleash, true);
            flag = true;
        }
        if (flag) {
            world.gameEvent(GameEvent.BLOCK_ATTACH, blockposition, GameEvent.Context.of(entityhuman));
            return InteractionResult.SUCCESS_SERVER;
        }
        if (entityleash != null) {
            entityleash.discard(null);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player entityhuman, Level world, BlockPos blockposition) {
        return LeadItem.bindPlayerMobs(entityhuman, world, blockposition, InteractionHand.MAIN_HAND);
    }
}

