/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class MinecartItem
extends Item {
    private final EntityType<? extends AbstractMinecart> type;

    public MinecartItem(EntityType<? extends AbstractMinecart> entitytypes, Item.Properties item_info) {
        super(item_info);
        this.type = entitytypes;
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        BlockPos blockposition;
        Level world = itemactioncontext.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (!iblockdata.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = itemactioncontext.getItemInHand();
        RailShape blockpropertytrackposition = iblockdata.getBlock() instanceof BaseRailBlock ? iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
        double d0 = 0.0;
        if (blockpropertytrackposition.isSlope()) {
            d0 = 0.5;
        }
        Vec3 vec3d = new Vec3((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.0625 + d0, (double)blockposition.getZ() + 0.5);
        AbstractMinecart entityminecartabstract = AbstractMinecart.createMinecart(world, vec3d.x, vec3d.y, vec3d.z, this.type, EntitySpawnReason.DISPENSER, itemstack, itemactioncontext.getPlayer());
        if (entityminecartabstract == null) {
            return InteractionResult.FAIL;
        }
        if (AbstractMinecart.useExperimentalMovement(world)) {
            for (Entity entity : world.getEntities(null, entityminecartabstract.getBoundingBox())) {
                if (!(entity instanceof AbstractMinecart)) continue;
                return InteractionResult.FAIL;
            }
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (CraftEventFactory.callEntityPlaceEvent(itemactioncontext, entityminecartabstract).isCancelled()) {
                return InteractionResult.FAIL;
            }
            if (!worldserver.addFreshEntity(entityminecartabstract)) {
                return InteractionResult.PASS;
            }
            worldserver.gameEvent(GameEvent.ENTITY_PLACE, blockposition, GameEvent.Context.of(itemactioncontext.getPlayer(), worldserver.getBlockState(blockposition.below())));
        }
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }
}

