/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShovelItem
extends Item {
    protected static final Map<Block, BlockState> FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.GRASS_BLOCK, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.PODZOL, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.MYCELIUM, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).build());

    public ShovelItem(ToolMaterial var0, float var1, float var2, Item.Properties var3) {
        super(var3.shovel(var0, var1, var2));
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        BlockState var3 = var1.getBlockState(var2);
        if (var0.getClickedFace() != Direction.DOWN) {
            Player var4 = var0.getPlayer();
            BlockState var5 = FLATTENABLES.get(var3.getBlock());
            BlockState var6 = null;
            if (var5 != null && var1.getBlockState(var2.above()).isAir()) {
                var1.playSound((Entity)var4, var2, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                var6 = var5;
            } else if (var3.getBlock() instanceof CampfireBlock && var3.getValue(CampfireBlock.LIT).booleanValue()) {
                if (!var1.isClientSide()) {
                    var1.levelEvent(null, 1009, var2, 0);
                }
                CampfireBlock.dowse(var0.getPlayer(), var1, var2, var3);
                var6 = (BlockState)var3.setValue(CampfireBlock.LIT, false);
            }
            if (var6 != null) {
                if (!var1.isClientSide()) {
                    var1.setBlock(var2, var6, 11);
                    var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.Context.of(var4, var6));
                    if (var4 != null) {
                        var0.getItemInHand().hurtAndBreak(1, (LivingEntity)var4, var0.getHand().asEquipmentSlot());
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

