/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;

public class SpyglassItem
extends Item {
    public static final int USE_DURATION = 1200;
    public static final float ZOOM_FOV_MODIFIER = 0.1f;

    public SpyglassItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public int getUseDuration(ItemStack var0, LivingEntity var1) {
        return 1200;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.SPYGLASS;
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        var1.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
        var1.awardStat(Stats.ITEM_USED.get(this));
        return ItemUtils.startUsingInstantly(var0, var1, var2);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, Level var1, LivingEntity var2) {
        this.stopUsing(var2);
        return var0;
    }

    @Override
    public boolean releaseUsing(ItemStack var0, Level var1, LivingEntity var2, int var3) {
        this.stopUsing(var2);
        return true;
    }

    private void stopUsing(LivingEntity var0) {
        var0.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
    }
}

