/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.entity.projectile.arrow.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float PROJECTILE_SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties item_info) {
        super(item_info);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.TRIDENT;
    }

    @Override
    public int getUseDuration(ItemStack itemstack, LivingEntity entityliving) {
        return 72000;
    }

    @Override
    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        if (entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            int j = this.getUseDuration(itemstack, entityliving) - i;
            if (j < 10) {
                return false;
            }
            float f = EnchantmentHelper.getTridentSpinAttackStrength(itemstack, entityhuman);
            if (f > 0.0f && !entityhuman.isInWaterOrRain()) {
                return false;
            }
            if (itemstack.nextDamageWillBreak()) {
                return false;
            }
            Holder<SoundEvent> holder = EnchantmentHelper.pickHighestLevel(itemstack, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
            entityhuman.awardStat(Stats.ITEM_USED.get(this));
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (f == 0.0f) {
                    ThrownTrident entitythrowntrident = Projectile.spawnProjectileFromRotation(ThrownTrident::new, worldserver, itemstack, entityhuman, 0.0f, 2.5f, 1.0f);
                    if (entitythrowntrident.isRemoved()) {
                        if (entityhuman instanceof ServerPlayer) {
                            ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                        }
                        return false;
                    }
                    itemstack.hurtWithoutBreaking(1, entityhuman);
                    ItemStack itemstack1 = itemstack.consumeAndReturn(1, entityhuman);
                    entitythrowntrident.pickupItemStack = itemstack1.copy();
                    if (entityhuman.hasInfiniteMaterials()) {
                        entitythrowntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.playSound((Entity)null, entitythrowntrident, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
                itemstack.hurtWithoutBreaking(1, entityhuman);
            }
            if (f > 0.0f) {
                float f1 = entityhuman.getYRot();
                float f2 = entityhuman.getXRot();
                float f3 = -Mth.sin(f1 * ((float)Math.PI / 180)) * Mth.cos(f2 * ((float)Math.PI / 180));
                float f4 = -Mth.sin(f2 * ((float)Math.PI / 180));
                float f5 = Mth.cos(f1 * ((float)Math.PI / 180)) * Mth.cos(f2 * ((float)Math.PI / 180));
                float f6 = Mth.sqrt(f3 * f3 + f4 * f4 + f5 * f5);
                CraftEventFactory.callPlayerRiptideEvent(entityhuman, itemstack, f3 *= f / f6, f4 *= f / f6, f5 *= f / f6);
                entityhuman.push(f3, f4, f5);
                entityhuman.startAutoSpinAttack(20, 8.0f, itemstack);
                if (entityhuman.onGround()) {
                    float f7 = 1.1999999f;
                    entityhuman.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                world.playSound((Entity)null, entityhuman, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.nextDamageWillBreak()) {
            return InteractionResult.FAIL;
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength(itemstack, entityhuman) > 0.0f && !entityhuman.isInWaterOrRain()) {
            return InteractionResult.FAIL;
        }
        entityhuman.startUsingItem(enumhand);
        return InteractionResult.CONSUME;
    }

    @Override
    public Projectile asProjectile(Level world, Position iposition, ItemStack itemstack, Direction enumdirection) {
        ThrownTrident entitythrowntrident = new ThrownTrident(world, iposition.x(), iposition.y(), iposition.z(), itemstack.copyWithCount(1));
        entitythrowntrident.pickup = AbstractArrow.Pickup.ALLOWED;
        return entitythrowntrident;
    }
}

