/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class WindChargeItem
extends Item
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 1.5f;

    public WindChargeItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var22) {
        ItemStack var32 = var1.getItemInHand(var22);
        if (var0 instanceof ServerLevel) {
            ServerLevel var42 = (ServerLevel)var0;
            Projectile.spawnProjectileFromRotation((var2, var3, var4) -> new WindCharge(var1, var0, var1.position().x(), var1.getEyePosition().y(), var1.position().z()), var42, var32, var1, 0.0f, PROJECTILE_SHOOT_POWER, 1.0f);
        }
        var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
        var1.awardStat(Stats.ITEM_USED.get(this));
        var32.consume(1, var1);
        return InteractionResult.SUCCESS;
    }

    @Override
    public Projectile asProjectile(Level var0, Position var1, ItemStack var2, Direction var3) {
        RandomSource var4 = var0.getRandom();
        double var5 = var4.triangle((double)var3.getStepX(), 0.11485000000000001);
        double var7 = var4.triangle((double)var3.getStepY(), 0.11485000000000001);
        double var9 = var4.triangle((double)var3.getStepZ(), 0.11485000000000001);
        Vec3 var11 = new Vec3(var5, var7, var9);
        WindCharge var12 = new WindCharge(var0, var1.x(), var1.y(), var1.z(), var11);
        var12.setDeltaMovement(var11);
        return var12;
    }

    @Override
    public void shoot(Projectile var0, double var1, double var3, double var5, float var7, float var8) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((var0, var1) -> DispenserBlock.getDispensePosition(var0, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1051).build();
    }
}

