/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record InstrumentComponent(EitherHolder<Instrument> instrument) implements TooltipProvider
{
    public static final Codec<InstrumentComponent> CODEC = EitherHolder.codec(Registries.INSTRUMENT, Instrument.CODEC).xmap(InstrumentComponent::new, InstrumentComponent::instrument);
    public static final StreamCodec<RegistryFriendlyByteBuf, InstrumentComponent> STREAM_CODEC = EitherHolder.streamCodec(Registries.INSTRUMENT, Instrument.STREAM_CODEC).map(InstrumentComponent::new, InstrumentComponent::instrument);

    public InstrumentComponent(Holder<Instrument> var0) {
        this(new EitherHolder<Instrument>(var0));
    }

    @Deprecated
    public InstrumentComponent(ResourceKey<Instrument> var0) {
        this(new EitherHolder<Instrument>(var0));
    }

    @Override
    public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var12, TooltipFlag var2, DataComponentGetter var3) {
        HolderLookup.Provider var4 = var0.registries();
        if (var4 == null) {
            return;
        }
        this.unwrap(var4).ifPresent(var1 -> {
            Component var2 = ComponentUtils.mergeStyles(((Instrument)var1.value()).description(), Style.EMPTY.withColor(ChatFormatting.GRAY));
            var12.accept(var2);
        });
    }

    public Optional<Holder<Instrument>> unwrap(HolderLookup.Provider var0) {
        return this.instrument.unwrap(var0);
    }
}

