/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriConsumer;
import org.jspecify.annotations.Nullable;

public record ItemAttributeModifiers(List<Entry> modifiers) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of());
    public static final Codec<ItemAttributeModifiers> CODEC = Entry.CODEC.listOf().xmap(ItemAttributeModifiers::new, ItemAttributeModifiers::modifiers);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public static Builder builder() {
        return new Builder();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<Attribute> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
        ImmutableList.Builder var3 = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry var5 : this.modifiers) {
            if (var5.matches(var0, var1.id())) continue;
            var3.add((Object)var5);
        }
        var3.add((Object)new Entry(var0, var1, var2));
        return new ItemAttributeModifiers((List<Entry>)var3.build());
    }

    public void forEach(EquipmentSlotGroup var0, TriConsumer<Holder<Attribute>, AttributeModifier, Display> var1) {
        for (Entry var3 : this.modifiers) {
            if (!var3.slot.equals(var0)) continue;
            var1.accept(var3.attribute, (Object)var3.modifier, (Object)var3.display);
        }
    }

    public void forEach(EquipmentSlotGroup var0, BiConsumer<Holder<Attribute>, AttributeModifier> var1) {
        for (Entry var3 : this.modifiers) {
            if (!var3.slot.equals(var0)) continue;
            var1.accept(var3.attribute, var3.modifier);
        }
    }

    public void forEach(EquipmentSlot var0, BiConsumer<Holder<Attribute>, AttributeModifier> var1) {
        for (Entry var3 : this.modifiers) {
            if (!var3.slot.test(var0)) continue;
            var1.accept(var3.attribute, var3.modifier);
        }
    }

    public double compute(Holder<Attribute> var0, double var1, EquipmentSlot var3) {
        double var4 = var1;
        for (Entry var7 : this.modifiers) {
            if (!var7.slot.test(var3) || var7.attribute != var0) continue;
            double var8 = var7.modifier.amount();
            var4 += (switch (var7.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> var8;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> var8 * var1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> var8 * var4;
            });
        }
        return var4;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
            this.entries.add((Object)new Entry(var0, var1, var2));
            return this;
        }

        public Builder add(Holder<Attribute> var0, AttributeModifier var1, EquipmentSlotGroup var2, Display var3) {
            this.entries.add((Object)new Entry(var0, var1, var2, var3));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build());
        }
    }

    public static final class Entry
    extends Record {
        final Holder<Attribute> attribute;
        final AttributeModifier modifier;
        final EquipmentSlotGroup slot;
        final Display display;
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(Entry::slot), (App)Display.CODEC.optionalFieldOf("display", (Object)Display.Default.INSTANCE).forGetter(Entry::display)).apply((Applicative)var0, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(Attribute.STREAM_CODEC, Entry::attribute, AttributeModifier.STREAM_CODEC, Entry::modifier, EquipmentSlotGroup.STREAM_CODEC, Entry::slot, Display.STREAM_CODEC, Entry::display, Entry::new);

        public Entry(Holder<Attribute> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
            this(var0, var1, var2, Display.attributeModifiers());
        }

        public Entry(Holder<Attribute> var0, AttributeModifier var1, EquipmentSlotGroup var2, Display var3) {
            this.attribute = var0;
            this.modifier = var1;
            this.slot = var2;
            this.display = var3;
        }

        public boolean matches(Holder<Attribute> var0, Identifier var1) {
            return var0.equals(this.attribute) && this.modifier.is(var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "attribute;modifier;slot;display", "attribute", "modifier", "slot", "display"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "attribute;modifier;slot;display", "attribute", "modifier", "slot", "display"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "attribute;modifier;slot;display", "attribute", "modifier", "slot", "display"}, this, var0);
        }

        public Holder<Attribute> attribute() {
            return this.attribute;
        }

        public AttributeModifier modifier() {
            return this.modifier;
        }

        public EquipmentSlotGroup slot() {
            return this.slot;
        }

        public Display display() {
            return this.display;
        }
    }

    public static interface Display {
        public static final Codec<Display> CODEC = Type.CODEC.dispatch("type", Display::type, var0 -> var0.codec);
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = Type.STREAM_CODEC.cast().dispatch(Display::type, Type::streamCodec);

        public static Display attributeModifiers() {
            return Default.INSTANCE;
        }

        public static Display hidden() {
            return Hidden.INSTANCE;
        }

        public static Display override(Component var0) {
            return new OverrideText(var0);
        }

        public Type type();

        public void apply(Consumer<Component> var1, @Nullable Player var2, Holder<Attribute> var3, AttributeModifier var4);

        public record Default() implements Display
        {
            static final Default INSTANCE = new Default();
            static final MapCodec<Default> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, Default> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public Type type() {
                return Type.DEFAULT;
            }

            @Override
            public void apply(Consumer<Component> var0, @Nullable Player var1, Holder<Attribute> var2, AttributeModifier var3) {
                double var4 = var3.amount();
                boolean var6 = false;
                if (var1 != null) {
                    if (var3.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                        var4 += var1.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                        var6 = true;
                    } else if (var3.is(Item.BASE_ATTACK_SPEED_ID)) {
                        var4 += var1.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                        var6 = true;
                    }
                }
                double var7 = var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? var4 * 100.0 : (var2.is(Attributes.KNOCKBACK_RESISTANCE) ? var4 * 10.0 : var4);
                if (var6) {
                    var0.accept(CommonComponents.space().append(Component.translatable("attribute.modifier.equals." + var3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(var7), Component.translatable(var2.value().getDescriptionId()))).withStyle(ChatFormatting.DARK_GREEN));
                } else if (var4 > 0.0) {
                    var0.accept(Component.translatable("attribute.modifier.plus." + var3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(var7), Component.translatable(var2.value().getDescriptionId())).withStyle(var2.value().getStyle(true)));
                } else if (var4 < 0.0) {
                    var0.accept(Component.translatable("attribute.modifier.take." + var3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(-var7), Component.translatable(var2.value().getDescriptionId())).withStyle(var2.value().getStyle(false)));
                }
            }
        }

        public record Hidden() implements Display
        {
            static final Hidden INSTANCE = new Hidden();
            static final MapCodec<Hidden> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, Hidden> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public Type type() {
                return Type.HIDDEN;
            }

            @Override
            public void apply(Consumer<Component> var0, @Nullable Player var1, Holder<Attribute> var2, AttributeModifier var3) {
            }
        }

        public record OverrideText(Component component) implements Display
        {
            static final MapCodec<OverrideText> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ComponentSerialization.CODEC.fieldOf("value").forGetter(OverrideText::component)).apply((Applicative)var0, OverrideText::new));
            static final StreamCodec<RegistryFriendlyByteBuf, OverrideText> STREAM_CODEC = StreamCodec.composite(ComponentSerialization.STREAM_CODEC, OverrideText::component, OverrideText::new);

            @Override
            public Type type() {
                return Type.OVERRIDE;
            }

            @Override
            public void apply(Consumer<Component> var0, @Nullable Player var1, Holder<Attribute> var2, AttributeModifier var3) {
                var0.accept(this.component);
            }
        }

        public static enum Type implements StringRepresentable
        {
            DEFAULT("default", 0, Default.CODEC, Default.STREAM_CODEC),
            HIDDEN("hidden", 1, Hidden.CODEC, Hidden.STREAM_CODEC),
            OVERRIDE("override", 2, OverrideText.CODEC, OverrideText.STREAM_CODEC);

            static final Codec<Type> CODEC;
            private static final IntFunction<Type> BY_ID;
            static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
            private final String name;
            private final int id;
            final MapCodec<? extends Display> codec;
            private final StreamCodec<RegistryFriendlyByteBuf, ? extends Display> streamCodec;

            private Type(String var2, int var3, MapCodec var4, StreamCodec var5) {
                this.name = var2;
                this.id = var3;
                this.codec = var4;
                this.streamCodec = var5;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private int id() {
                return this.id;
            }

            private StreamCodec<RegistryFriendlyByteBuf, ? extends Display> streamCodec() {
                return this.streamCodec;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Type::values);
                BY_ID = ByIdMap.continuous(Type::id, Type.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
                STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Type::id);
            }
        }
    }
}

