/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;

public record PiercingWeapon(boolean dealsKnockback, boolean dismounts, Optional<Holder<SoundEvent>> sound, Optional<Holder<SoundEvent>> hitSound) {
    public static final Codec<PiercingWeapon> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::dealsKnockback), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::dismounts), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(PiercingWeapon::sound), (App)SoundEvent.CODEC.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::hitSound)).apply((Applicative)var0, PiercingWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PiercingWeapon> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, PiercingWeapon::dealsKnockback, ByteBufCodecs.BOOL, PiercingWeapon::dismounts, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::sound, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::hitSound, PiercingWeapon::new);

    public void makeSound(Entity var0) {
        this.sound.ifPresent(var1 -> var0.level().playSound(var0, var0.getX(), var0.getY(), var0.getZ(), (Holder<SoundEvent>)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public void makeHitSound(Entity var0) {
        this.hitSound.ifPresent(var1 -> var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), (Holder<SoundEvent>)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public static boolean canHitEntity(Entity var0, Entity var1) {
        if (var1.isInvulnerable() || !var1.isAlive()) {
            return false;
        }
        if (var1 instanceof Interaction) {
            return true;
        }
        if (!var1.canBeHitByProjectile()) {
            return false;
        }
        if (var1 instanceof Player) {
            Player var3;
            Player var2 = (Player)var1;
            if (var0 instanceof Player && !(var3 = (Player)var0).canHarmPlayer(var2)) {
                return false;
            }
        }
        return !var0.isPassengerOfSameVehicle(var1);
    }

    public void attack(LivingEntity var02, EquipmentSlot var12) {
        float var2 = (float)var02.getAttributeValue(Attributes.ATTACK_DAMAGE);
        AttackRange var3 = var02.entityAttackRange();
        boolean var4 = false;
        for (EntityHitResult var6 : (Collection)ProjectileUtil.getHitEntitiesAlong(var02, var3, var1 -> PiercingWeapon.canHitEntity(var02, var1), ClipContext.Block.COLLIDER).map(var0 -> List.of(), var0 -> var0)) {
            var4 |= var02.stabAttack(var12, var6.getEntity(), var2, true, this.dealsKnockback, this.dismounts);
        }
        var02.onAttack();
        var02.lungeForwardMaybe();
        if (var4) {
            this.makeHitSound(var02);
        }
        this.makeSound(var02);
        var02.swing(InteractionHand.MAIN_HAND, false);
    }
}

