/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public class CraftingInput
implements RecipeInput {
    public static final CraftingInput EMPTY = new CraftingInput(0, 0, List.of());
    private final int width;
    private final int height;
    private final List<ItemStack> items;
    private final StackedItemContents stackedContents = new StackedItemContents();
    private final int ingredientCount;

    private CraftingInput(int var0, int var1, List<ItemStack> var2) {
        this.width = var0;
        this.height = var1;
        this.items = var2;
        int var3 = 0;
        for (ItemStack var5 : var2) {
            if (var5.isEmpty()) continue;
            ++var3;
            this.stackedContents.accountStack(var5, 1);
        }
        this.ingredientCount = var3;
    }

    public static CraftingInput of(int var0, int var1, List<ItemStack> var2) {
        return CraftingInput.ofPositioned(var0, var1, var2).input();
    }

    public static Positioned ofPositioned(int var0, int var1, List<ItemStack> var2) {
        int var8;
        int var7;
        if (var0 == 0 || var1 == 0) {
            return Positioned.EMPTY;
        }
        int var3 = var0 - 1;
        int var4 = 0;
        int var5 = var1 - 1;
        int var6 = 0;
        for (var7 = 0; var7 < var1; ++var7) {
            var8 = 1;
            for (int var9 = 0; var9 < var0; ++var9) {
                ItemStack var10 = var2.get(var9 + var7 * var0);
                if (var10.isEmpty()) continue;
                var3 = Math.min(var3, var9);
                var4 = Math.max(var4, var9);
                var8 = 0;
            }
            if (var8 != 0) continue;
            var5 = Math.min(var5, var7);
            var6 = Math.max(var6, var7);
        }
        var7 = var4 - var3 + 1;
        var8 = var6 - var5 + 1;
        if (var7 <= 0 || var8 <= 0) {
            return Positioned.EMPTY;
        }
        if (var7 == var0 && var8 == var1) {
            return new Positioned(new CraftingInput(var0, var1, var2), var3, var5);
        }
        ArrayList<ItemStack> var9 = new ArrayList<ItemStack>(var7 * var8);
        for (int var10 = 0; var10 < var8; ++var10) {
            for (int var11 = 0; var11 < var7; ++var11) {
                int var12 = var11 + var3 + (var10 + var5) * var0;
                var9.add(var2.get(var12));
            }
        }
        return new Positioned(new CraftingInput(var7, var8, var9), var3, var5);
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.items.get(var0);
    }

    public ItemStack getItem(int var0, int var1) {
        return this.items.get(var0 + var1 * this.width);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ingredientCount == 0;
    }

    public StackedItemContents stackedContents() {
        return this.stackedContents;
    }

    public List<ItemStack> items() {
        return this.items;
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof CraftingInput) {
            CraftingInput var1 = (CraftingInput)var0;
            return this.width == var1.width && this.height == var1.height && this.ingredientCount == var1.ingredientCount && ItemStack.listMatches(this.items, var1.items);
        }
        return false;
    }

    public int hashCode() {
        int var0 = ItemStack.hashStackList(this.items);
        var0 = 31 * var0 + this.width;
        var0 = 31 * var0 + this.height;
        return var0;
    }

    public record Positioned(CraftingInput input, int left, int top) {
        public static final Positioned EMPTY = new Positioned(EMPTY, 0, 0);
    }
}

