/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireworkStarRecipe
extends CustomRecipe {
    private static final Map<Item, FireworkExplosion.Shape> SHAPE_BY_ITEM = Map.of(Items.FIRE_CHARGE, FireworkExplosion.Shape.LARGE_BALL, Items.FEATHER, FireworkExplosion.Shape.BURST, Items.GOLD_NUGGET, FireworkExplosion.Shape.STAR, Items.SKELETON_SKULL, FireworkExplosion.Shape.CREEPER, Items.WITHER_SKELETON_SKULL, FireworkExplosion.Shape.CREEPER, Items.CREEPER_HEAD, FireworkExplosion.Shape.CREEPER, Items.PLAYER_HEAD, FireworkExplosion.Shape.CREEPER, Items.DRAGON_HEAD, FireworkExplosion.Shape.CREEPER, Items.ZOMBIE_HEAD, FireworkExplosion.Shape.CREEPER, Items.PIGLIN_HEAD, FireworkExplosion.Shape.CREEPER);
    private static final Ingredient TRAIL_INGREDIENT = Ingredient.of((ItemLike)Items.DIAMOND);
    private static final Ingredient TWINKLE_INGREDIENT = Ingredient.of((ItemLike)Items.GLOWSTONE_DUST);
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.of((ItemLike)Items.GUNPOWDER);

    public FireworkStarRecipe(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        if (var0.ingredientCount() < 2) {
            return false;
        }
        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        boolean var5 = false;
        boolean var6 = false;
        for (int var7 = 0; var7 < var0.size(); ++var7) {
            ItemStack var8 = var0.getItem(var7);
            if (var8.isEmpty()) continue;
            if (SHAPE_BY_ITEM.containsKey(var8.getItem())) {
                if (var4) {
                    return false;
                }
                var4 = true;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(var8)) {
                if (var6) {
                    return false;
                }
                var6 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(var8)) {
                if (var5) {
                    return false;
                }
                var5 = true;
                continue;
            }
            if (GUNPOWDER_INGREDIENT.test(var8)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (var8.getItem() instanceof DyeItem) {
                var3 = true;
                continue;
            }
            return false;
        }
        return var2 && var3;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        FireworkExplosion.Shape var2 = FireworkExplosion.Shape.SMALL_BALL;
        boolean var3 = false;
        boolean var4 = false;
        IntArrayList var5 = new IntArrayList();
        for (int var6 = 0; var6 < var0.size(); ++var6) {
            ItemStack var7 = var0.getItem(var6);
            if (var7.isEmpty()) continue;
            FireworkExplosion.Shape var8 = SHAPE_BY_ITEM.get(var7.getItem());
            if (var8 != null) {
                var2 = var8;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(var7)) {
                var3 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(var7)) {
                var4 = true;
                continue;
            }
            Item item = var7.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem var9 = (DyeItem)item;
            var5.add(var9.getDyeColor().getFireworkColor());
        }
        ItemStack var6 = new ItemStack(Items.FIREWORK_STAR);
        var6.set(DataComponents.FIREWORK_EXPLOSION, new FireworkExplosion(var2, (IntList)var5, IntList.of(), var4, var3));
        return var6;
    }

    @Override
    public RecipeSerializer<FireworkStarRecipe> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR;
    }
}

