/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.crafting.Ingredient;

public class PlacementInfo {
    public static final int EMPTY_SLOT = -1;
    public static final PlacementInfo NOT_PLACEABLE = new PlacementInfo(List.of(), IntList.of());
    private final List<Ingredient> ingredients;
    private final IntList slotsToIngredientIndex;

    private PlacementInfo(List<Ingredient> var0, IntList var1) {
        this.ingredients = var0;
        this.slotsToIngredientIndex = var1;
    }

    public static PlacementInfo create(Ingredient var0) {
        if (var0.isEmpty()) {
            return NOT_PLACEABLE;
        }
        return new PlacementInfo(List.of(var0), IntList.of((int)0));
    }

    public static PlacementInfo createFromOptionals(List<Optional<Ingredient>> var0) {
        int var1 = var0.size();
        ArrayList<Ingredient> var2 = new ArrayList<Ingredient>(var1);
        IntArrayList var3 = new IntArrayList(var1);
        int var4 = 0;
        for (Optional<Ingredient> var6 : var0) {
            if (var6.isPresent()) {
                Ingredient var7 = var6.get();
                if (var7.isEmpty()) {
                    return NOT_PLACEABLE;
                }
                var2.add(var7);
                var3.add(var4++);
                continue;
            }
            var3.add(-1);
        }
        return new PlacementInfo(var2, (IntList)var3);
    }

    public static PlacementInfo create(List<Ingredient> var0) {
        int var1 = var0.size();
        IntArrayList var2 = new IntArrayList(var1);
        for (int var3 = 0; var3 < var1; ++var3) {
            Ingredient var4 = var0.get(var3);
            if (var4.isEmpty()) {
                return NOT_PLACEABLE;
            }
            var2.add(var3);
        }
        return new PlacementInfo(var0, (IntList)var2);
    }

    public IntList slotsToIngredientIndex() {
        return this.slotsToIngredientIndex;
    }

    public List<Ingredient> ingredients() {
        return this.ingredients;
    }

    public boolean isImpossibleToPlace() {
        return this.slotsToIngredientIndex.isEmpty();
    }
}

