/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class RecipeManager
extends SimplePreparableReloadListener<RecipeMap>
implements RecipeAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, IngredientExtractor> RECIPE_PROPERTY_SETS = Map.of(RecipePropertySet.SMITHING_ADDITION, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.additionIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_BASE, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = Optional.of(smithingrecipe.baseIngredient());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_TEMPLATE, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.templateIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.SMELTING), RecipePropertySet.BLAST_FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.BLASTING), RecipePropertySet.SMOKER_INPUT, RecipeManager.forSingleInput(RecipeType.SMOKING), RecipePropertySet.CAMPFIRE_INPUT, RecipeManager.forSingleInput(RecipeType.CAMPFIRE_COOKING));
    private static final FileToIdConverter RECIPE_LISTER = FileToIdConverter.registry(Registries.RECIPE);
    private final HolderLookup.Provider registries;
    public RecipeMap recipes = RecipeMap.EMPTY;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySets = Map.of();
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes = SelectableRecipe.SingleInputSet.empty();
    private List<ServerDisplayInfo> allDisplays = List.of();
    private Map<ResourceKey<Recipe<?>>, List<ServerDisplayInfo>> recipeToDisplay = Map.of();
    private FeatureFlagSet featureflagset;

    public RecipeManager(HolderLookup.Provider holderlookup_a) {
        this.registries = holderlookup_a;
    }

    @Override
    protected RecipeMap prepare(ResourceManager iresourcemanager, ProfilerFiller gameprofilerfiller) {
        TreeMap<Identifier, Recipe> sortedmap = new TreeMap<Identifier, Recipe>();
        SimpleJsonResourceReloadListener.scanDirectory(iresourcemanager, RECIPE_LISTER, this.registries.createSerializationContext(JsonOps.INSTANCE), Recipe.CODEC, sortedmap);
        ArrayList list = new ArrayList(sortedmap.size());
        sortedmap.forEach((minecraftkey, irecipe) -> {
            ResourceKey<Recipe<?>> resourcekey = ResourceKey.create(Registries.RECIPE, minecraftkey);
            RecipeHolder<Recipe> recipeholder = new RecipeHolder<Recipe>(resourcekey, (Recipe)irecipe);
            list.add(recipeholder);
        });
        return RecipeMap.create(list);
    }

    @Override
    protected void apply(RecipeMap recipemap, ResourceManager iresourcemanager, ProfilerFiller gameprofilerfiller) {
        this.recipes = recipemap;
        LOGGER.info("Loaded {} recipes", (Object)recipemap.values().size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        this.recipes.addRecipe(irecipe);
        this.finalizeRecipeLoading();
    }

    public void finalizeRecipeLoading() {
        if (this.featureflagset != null) {
            this.finalizeRecipeLoading(this.featureflagset);
            MinecraftServer.getServer().getPlayerList().reloadRecipes();
        }
    }

    public void finalizeRecipeLoading(FeatureFlagSet featureflagset) {
        this.featureflagset = featureflagset;
        ArrayList list = new ArrayList();
        List<IngredientCollector> list1 = RECIPE_PROPERTY_SETS.entrySet().stream().map(entry -> new IngredientCollector((ResourceKey)entry.getKey(), (IngredientExtractor)entry.getValue())).toList();
        this.recipes.values().forEach(recipeholder -> {
            Object irecipe = recipeholder.value();
            if (!irecipe.isSpecial() && irecipe.placementInfo().isImpossibleToPlace()) {
                LOGGER.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)recipeholder.id().identifier());
            } else {
                StonecutterRecipe recipestonecutting;
                list1.forEach(craftingmanager_b -> craftingmanager_b.accept((Recipe<?>)irecipe));
                if (irecipe instanceof StonecutterRecipe && RecipeManager.isIngredientEnabled(featureflagset, (recipestonecutting = (StonecutterRecipe)irecipe).input()) && recipestonecutting.resultDisplay().isEnabled(featureflagset)) {
                    list.add(new SelectableRecipe.SingleInputEntry(recipestonecutting.input(), new SelectableRecipe(recipestonecutting.resultDisplay(), Optional.of(recipeholder))));
                }
            }
        });
        this.propertySets = list1.stream().collect(Collectors.toUnmodifiableMap(craftingmanager_b -> craftingmanager_b.key, craftingmanager_b -> craftingmanager_b.asPropertySet(featureflagset)));
        this.stonecutterRecipes = new SelectableRecipe.SingleInputSet(list);
        this.allDisplays = RecipeManager.unpackRecipeInfo(this.recipes.values(), featureflagset);
        this.recipeToDisplay = this.allDisplays.stream().collect(Collectors.groupingBy(craftingmanager_d -> craftingmanager_d.parent.id(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<Ingredient> filterDisabled(FeatureFlagSet featureflagset, List<Ingredient> list) {
        list.removeIf(recipeitemstack -> !RecipeManager.isIngredientEnabled(featureflagset, recipeitemstack));
        return list;
    }

    private static boolean isIngredientEnabled(FeatureFlagSet featureflagset, Ingredient recipeitemstack) {
        return recipeitemstack.items().allMatch(holder -> ((Item)holder.value()).isEnabled(featureflagset));
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipes, I i0, Level world, @Nullable ResourceKey<Recipe<?>> resourcekey) {
        RecipeHolder<T> recipeholder = resourcekey != null ? this.byKeyTyped(recipes, resourcekey) : null;
        return this.getRecipeFor(recipes, i0, world, recipeholder);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipes, I i0, Level world, @Nullable RecipeHolder<T> recipeholder) {
        return recipeholder != null && recipeholder.value().matches(i0, world) ? Optional.of(recipeholder) : this.getRecipeFor(recipes, i0, world);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipes, I i0, Level world) {
        List<RecipeHolder<T>> list = this.recipes.getRecipesFor(recipes, i0, world).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public Optional<RecipeHolder<?>> byKey(ResourceKey<Recipe<?>> resourcekey) {
        return Optional.ofNullable(this.recipes.byKey(resourcekey));
    }

    private <T extends Recipe<?>> @Nullable RecipeHolder<T> byKeyTyped(RecipeType<T> recipes, ResourceKey<Recipe<?>> resourcekey) {
        RecipeHolder<?> recipeholder = this.recipes.byKey(resourcekey);
        return recipeholder != null && recipeholder.value().getType().equals(recipes) ? recipeholder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> getSynchronizedItemProperties() {
        return this.propertySets;
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getSynchronizedStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    @Override
    public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> resourcekey) {
        return this.propertySets.getOrDefault(resourcekey, RecipePropertySet.EMPTY);
    }

    @Override
    public SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.recipes.values();
    }

    public @Nullable ServerDisplayInfo getRecipeFromDisplay(RecipeDisplayId recipedisplayid) {
        int i = recipedisplayid.index();
        return i >= 0 && i < this.allDisplays.size() ? this.allDisplays.get(i) : null;
    }

    public void listDisplaysForRecipe(ResourceKey<Recipe<?>> resourcekey, Consumer<RecipeDisplayEntry> consumer) {
        List<ServerDisplayInfo> list = this.recipeToDisplay.get(resourcekey);
        if (list != null) {
            list.forEach(craftingmanager_d -> consumer.accept(craftingmanager_d.display));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceKey<Recipe<?>> resourcekey, JsonObject jsonobject, HolderLookup.Provider holderlookup_a) {
        Recipe irecipe = (Recipe)Recipe.CODEC.parse(holderlookup_a.createSerializationContext(JsonOps.INSTANCE), (Object)jsonobject).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(resourcekey, irecipe);
    }

    public boolean removeRecipe(ResourceKey<Recipe<?>> mcKey) {
        boolean removed = this.recipes.removeRecipe(mcKey);
        if (removed) {
            this.finalizeRecipeLoading();
        }
        return removed;
    }

    public void clearRecipes() {
        this.recipes = RecipeMap.create(Collections.emptyList());
        this.finalizeRecipeLoading();
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> recipes) {
        return new CachedCheck<I, T>(){
            private @Nullable ResourceKey<Recipe<?>> lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I i0, ServerLevel worldserver) {
                RecipeManager craftingmanager = worldserver.recipeAccess();
                Optional optional = craftingmanager.getRecipeFor(recipes, i0, (Level)worldserver, this.lastRecipe);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.lastRecipe = recipeholder.id();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<ServerDisplayInfo> unpackRecipeInfo(Iterable<RecipeHolder<?>> iterable, FeatureFlagSet featureflagset) {
        ArrayList<ServerDisplayInfo> list = new ArrayList<ServerDisplayInfo>();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeholder : iterable) {
            Object irecipe = recipeholder.value();
            OptionalInt optionalint = irecipe.group().isEmpty() ? OptionalInt.empty() : OptionalInt.of(object2intmap.computeIfAbsent((Object)irecipe.group(), arg_0 -> RecipeManager.lambda$unpackRecipeInfo$13((Object2IntMap)object2intmap, arg_0)));
            Optional<Object> optional = irecipe.isSpecial() ? Optional.empty() : Optional.of(irecipe.placementInfo().ingredients());
            for (RecipeDisplay recipedisplay : irecipe.display()) {
                if (!recipedisplay.isEnabled(featureflagset)) continue;
                int i = list.size();
                RecipeDisplayId recipedisplayid = new RecipeDisplayId(i);
                RecipeDisplayEntry recipedisplayentry = new RecipeDisplayEntry(recipedisplayid, recipedisplay, optionalint, irecipe.recipeBookCategory(), optional);
                list.add(new ServerDisplayInfo(recipedisplayentry, recipeholder));
            }
        }
        return list;
    }

    private static IngredientExtractor forSingleInput(RecipeType<? extends SingleItemRecipe> recipes) {
        return irecipe -> {
            Optional<Object> optional;
            if (irecipe.getType() == recipes && irecipe instanceof SingleItemRecipe) {
                SingleItemRecipe recipesingleitem = (SingleItemRecipe)irecipe;
                optional = Optional.of(recipesingleitem.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap object2intmap, Object object) {
        return object2intmap.size();
    }

    public record ServerDisplayInfo(RecipeDisplayEntry display, RecipeHolder<?> parent) {
    }

    @FunctionalInterface
    public static interface IngredientExtractor {
        public Optional<Ingredient> apply(Recipe<?> var1);
    }

    public static class IngredientCollector
    implements Consumer<Recipe<?>> {
        final ResourceKey<RecipePropertySet> key;
        private final IngredientExtractor extractor;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

        protected IngredientCollector(ResourceKey<RecipePropertySet> resourcekey, IngredientExtractor craftingmanager_c) {
            this.key = resourcekey;
            this.extractor = craftingmanager_c;
        }

        @Override
        public void accept(Recipe<?> irecipe) {
            Optional<Ingredient> optional = this.extractor.apply(irecipe);
            List<Ingredient> list = this.ingredients;
            Objects.requireNonNull(this.ingredients);
            optional.ifPresent(list::add);
        }

        public RecipePropertySet asPropertySet(FeatureFlagSet featureflagset) {
            return RecipePropertySet.create(RecipeManager.filterDisabled(featureflagset, this.ingredients));
        }
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, ServerLevel var2);
    }
}

