/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class RepairItemRecipe
extends CustomRecipe {
    public RepairItemRecipe(CraftingBookCategory var0) {
        super(var0);
    }

    private static @Nullable Pair<ItemStack, ItemStack> getItemsToCombine(CraftingInput var0) {
        if (var0.ingredientCount() != 2) {
            return null;
        }
        ItemStack var1 = null;
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            ItemStack var3 = var0.getItem(var2);
            if (var3.isEmpty()) continue;
            if (var1 == null) {
                var1 = var3;
                continue;
            }
            return RepairItemRecipe.canCombine(var1, var3) ? Pair.of((Object)var1, (Object)var3) : null;
        }
        return null;
    }

    private static boolean canCombine(ItemStack var0, ItemStack var1) {
        return var1.is(var0.getItem()) && var0.getCount() == 1 && var1.getCount() == 1 && var0.has(DataComponents.MAX_DAMAGE) && var1.has(DataComponents.MAX_DAMAGE) && var0.has(DataComponents.DAMAGE) && var1.has(DataComponents.DAMAGE);
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        return RepairItemRecipe.getItemsToCombine(var0) != null;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        Pair<ItemStack, ItemStack> var2 = RepairItemRecipe.getItemsToCombine(var0);
        if (var2 == null) {
            return ItemStack.EMPTY;
        }
        ItemStack var3 = (ItemStack)var2.getFirst();
        ItemStack var4 = (ItemStack)var2.getSecond();
        int var5 = Math.max(var3.getMaxDamage(), var4.getMaxDamage());
        int var6 = var3.getMaxDamage() - var3.getDamageValue();
        int var7 = var4.getMaxDamage() - var4.getDamageValue();
        int var8 = var6 + var7 + var5 * 5 / 100;
        ItemStack var9 = new ItemStack(var3.getItem());
        var9.set(DataComponents.MAX_DAMAGE, var5);
        var9.setDamageValue(Math.max(var5 - var8, 0));
        ItemEnchantments var10 = EnchantmentHelper.getEnchantmentsForCrafting(var3);
        ItemEnchantments var11 = EnchantmentHelper.getEnchantmentsForCrafting(var4);
        EnchantmentHelper.updateEnchantments(var9, var32 -> var1.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(var0 -> var0.is(EnchantmentTags.CURSE)).forEach(var3 -> {
            int var4 = Math.max(var10.getLevel((Holder<Enchantment>)var3), var11.getLevel((Holder<Enchantment>)var3));
            if (var4 > 0) {
                var32.upgrade((Holder<Enchantment>)var3, var4);
            }
        }));
        return var9;
    }

    @Override
    public RecipeSerializer<RepairItemRecipe> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

