/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.jspecify.annotations.Nullable;

public class ShapedRecipe
implements CraftingRecipe {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;
    private @Nullable PlacementInfo placementInfo;

    public ShapedRecipe(String s, CraftingBookCategory craftingbookcategory, ShapedRecipePattern shapedrecipepattern, ItemStack itemstack, boolean flag) {
        this.group = s;
        this.category = craftingbookcategory;
        this.pattern = shapedrecipepattern;
        this.result = itemstack;
        this.showNotification = flag;
    }

    public ShapedRecipe(String s, CraftingBookCategory craftingbookcategory, ShapedRecipePattern shapedrecipepattern, ItemStack itemstack) {
        this(s, craftingbookcategory, shapedrecipepattern, itemstack, true);
    }

    public org.bukkit.inventory.ShapedRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.result);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, result, this);
        recipe.setGroup(this.group);
        recipe.setCategory(CraftRecipe.getCategory(this.category()));
        block0 : switch (this.pattern.height()) {
            case 1: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c = 'a';
        for (Optional<Ingredient> list : this.pattern.ingredients()) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != null) {
                recipe.setIngredient(c, choice);
            }
            c = (char)(c + 1);
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<? extends ShapedRecipe> getSerializer() {
        return RecipeSerializer.SHAPED_RECIPE;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @VisibleForTesting
    public List<Optional<Ingredient>> getIngredients() {
        return this.pattern.ingredients();
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(this.pattern.ingredients());
        }
        return this.placementInfo;
    }

    @Override
    public boolean showNotification() {
        return this.showNotification;
    }

    @Override
    public boolean matches(CraftingInput craftinginput, Level world) {
        return this.pattern.matches(craftinginput);
    }

    @Override
    public ItemStack assemble(CraftingInput craftinginput, HolderLookup.Provider holderlookup_a) {
        return this.result.copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.pattern.ingredients().stream().map(optional -> optional.map(Ingredient::display).orElse(SlotDisplay.Empty.INSTANCE)).toList(), new SlotDisplay.ItemStackSlotDisplay(this.result), new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipe> {
        public static final MapCodec<ShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedrecipes -> shapedrecipes.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapedrecipes -> shapedrecipes.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedrecipes -> shapedrecipes.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapedrecipes -> shapedrecipes.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(shapedrecipes -> shapedrecipes.showNotification)).apply((Applicative)instance, ShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<ShapedRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedRecipe fromNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            String s = registryfriendlybytebuf.readUtf();
            CraftingBookCategory craftingbookcategory = registryfriendlybytebuf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(registryfriendlybytebuf);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(registryfriendlybytebuf);
            boolean flag = registryfriendlybytebuf.readBoolean();
            return new ShapedRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf, ShapedRecipe shapedrecipes) {
            registryfriendlybytebuf.writeUtf(shapedrecipes.group);
            registryfriendlybytebuf.writeEnum(shapedrecipes.category);
            ShapedRecipePattern.STREAM_CODEC.encode(registryfriendlybytebuf, shapedrecipes.pattern);
            ItemStack.STREAM_CODEC.encode(registryfriendlybytebuf, shapedrecipes.result);
            registryfriendlybytebuf.writeBoolean(shapedrecipes.showNotification);
        }
    }
}

