/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ChangeItemDamage(LevelBasedValue amount) implements EnchantmentEntityEffect
{
    public static final MapCodec<ChangeItemDamage> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(var0 -> var0.amount)).apply((Applicative)var02, ChangeItemDamage::new));

    @Override
    public void apply(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4) {
        ItemStack var5 = var2.itemStack();
        if (var5.has(DataComponents.MAX_DAMAGE) && var5.has(DataComponents.DAMAGE)) {
            ServerPlayer var7;
            LivingEntity livingEntity = var2.owner();
            ServerPlayer var6 = livingEntity instanceof ServerPlayer ? (var7 = (ServerPlayer)livingEntity) : null;
            int var8 = (int)this.amount.calculate(var1);
            var5.hurtAndBreak(var8, var0, var6, var2.onBreak());
        }
    }

    public MapCodec<ChangeItemDamage> codec() {
        return CODEC;
    }
}

