/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyEntityImpulse;
import net.minecraft.world.item.enchantment.effects.ApplyExhaustion;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.ChangeItemDamage;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.ReplaceBlock;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.RunFunction;
import net.minecraft.world.item.enchantment.effects.SetBlockProperties;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.phys.Vec3;

public interface EnchantmentEntityEffect
extends EnchantmentLocationBasedEffect {
    public static final Codec<EnchantmentEntityEffect> CODEC = BuiltInRegistries.ENCHANTMENT_ENTITY_EFFECT_TYPE.byNameCodec().dispatch(EnchantmentEntityEffect::codec, Function.identity());

    public static MapCodec<? extends EnchantmentEntityEffect> bootstrap(Registry<MapCodec<? extends EnchantmentEntityEffect>> var0) {
        Registry.register(var0, "all_of", AllOf.EntityEffects.CODEC);
        Registry.register(var0, "apply_mob_effect", ApplyMobEffect.CODEC);
        Registry.register(var0, "change_item_damage", ChangeItemDamage.CODEC);
        Registry.register(var0, "damage_entity", DamageEntity.CODEC);
        Registry.register(var0, "explode", ExplodeEffect.CODEC);
        Registry.register(var0, "ignite", Ignite.CODEC);
        Registry.register(var0, "apply_impulse", ApplyEntityImpulse.CODEC);
        Registry.register(var0, "apply_exhaustion", ApplyExhaustion.CODEC);
        Registry.register(var0, "play_sound", PlaySoundEffect.CODEC);
        Registry.register(var0, "replace_block", ReplaceBlock.CODEC);
        Registry.register(var0, "replace_disk", ReplaceDisk.CODEC);
        Registry.register(var0, "run_function", RunFunction.CODEC);
        Registry.register(var0, "set_block_properties", SetBlockProperties.CODEC);
        Registry.register(var0, "spawn_particles", SpawnParticlesEffect.CODEC);
        return Registry.register(var0, "summon_entity", SummonEntityEffect.CODEC);
    }

    public void apply(ServerLevel var1, int var2, EnchantedItemInUse var3, Entity var4, Vec3 var5);

    @Override
    default public void onChangedBlock(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4, boolean var5) {
        this.apply(var0, var1, var2, var3, var4);
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec();
}

