/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public record ReplaceDisk(LevelBasedValue radius, LevelBasedValue height, Vec3i offset, Optional<BlockPredicate> predicate, BlockStateProvider blockState, Optional<Holder<GameEvent>> triggerGameEvent) implements EnchantmentEntityEffect
{
    public static final MapCodec<ReplaceDisk> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(ReplaceDisk::radius), (App)LevelBasedValue.CODEC.fieldOf("height").forGetter(ReplaceDisk::height), (App)Vec3i.CODEC.optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(ReplaceDisk::offset), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(ReplaceDisk::predicate), (App)BlockStateProvider.CODEC.fieldOf("block_state").forGetter(ReplaceDisk::blockState), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(ReplaceDisk::triggerGameEvent)).apply((Applicative)instance, ReplaceDisk::new));

    @Override
    public void apply(ServerLevel worldserver, int i, EnchantedItemInUse enchantediteminuse, Entity entity, Vec3 vec3d) {
        BlockPos blockposition = BlockPos.containing(vec3d).offset(this.offset);
        RandomSource randomsource = entity.getRandom();
        int j = (int)this.radius.calculate(i);
        int k = (int)this.height.calculate(i);
        for (BlockPos blockposition1 : BlockPos.betweenClosed(blockposition.offset(-j, 0, -j), blockposition.offset(j, Math.min(k - 1, 0), j))) {
            if (!(blockposition1.distToCenterSqr(vec3d.x(), (double)blockposition1.getY() + 0.5, vec3d.z()) < (double)Mth.square(j)) || !this.predicate.map(blockpredicate -> blockpredicate.test(worldserver, blockposition1)).orElse(true).booleanValue() || !CraftEventFactory.handleBlockFormEvent((Level)worldserver, blockposition1, this.blockState.getState(randomsource, blockposition1), entity)) continue;
            this.triggerGameEvent.ifPresent(holder -> worldserver.gameEvent(entity, (Holder<GameEvent>)holder, blockposition1));
        }
    }

    public MapCodec<ReplaceDisk> codec() {
        return CODEC;
    }
}

