/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.slot.SlotCollection;
import net.minecraft.world.item.slot.SlotSource;
import net.minecraft.world.item.slot.SlotSources;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;

public abstract class CompositeSlotSource
implements SlotSource {
    protected final List<SlotSource> terms;
    private final Function<LootContext, SlotCollection> compositeSlotSource;

    protected CompositeSlotSource(List<SlotSource> var0) {
        this.terms = var0;
        this.compositeSlotSource = SlotSources.group(var0);
    }

    protected static <T extends CompositeSlotSource> MapCodec<T> createCodec(Function<List<SlotSource>, T> var0) {
        return RecordCodecBuilder.mapCodec(var1 -> var1.group((App)SlotSources.CODEC.listOf().fieldOf("terms").forGetter(var0 -> var0.terms)).apply((Applicative)var1, var0));
    }

    protected static <T extends CompositeSlotSource> Codec<T> createInlineCodec(Function<List<SlotSource>, T> var02) {
        return SlotSources.CODEC.listOf().xmap(var02, var0 -> var0.terms);
    }

    public abstract MapCodec<? extends CompositeSlotSource> codec();

    @Override
    public SlotCollection provide(LootContext var0) {
        return this.compositeSlotSource.apply(var0);
    }

    @Override
    public void validate(ValidationContext var0) {
        SlotSource.super.validate(var0);
        for (int var1 = 0; var1 < this.terms.size(); ++var1) {
            this.terms.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("terms", var1)));
        }
    }
}

