/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.inventory.SlotRanges;
import net.minecraft.world.item.slot.SlotCollection;
import net.minecraft.world.item.slot.SlotSource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextArg;

public class RangeSlotSource
implements SlotSource {
    public static final MapCodec<RangeSlotSource> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)LootContextArg.ENTITY_OR_BLOCK.fieldOf("source").forGetter(var0 -> var0.source), (App)SlotRanges.CODEC.fieldOf("slots").forGetter(var0 -> var0.slotRange)).apply((Applicative)var02, RangeSlotSource::new));
    private final LootContextArg<Object> source;
    private final SlotRange slotRange;

    private RangeSlotSource(LootContextArg<Object> var0, SlotRange var1) {
        this.source = var0;
        this.slotRange = var1;
    }

    public MapCodec<RangeSlotSource> codec() {
        return MAP_CODEC;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    @Override
    public final SlotCollection provide(LootContext var0) {
        Object var1 = this.source.get(var0);
        if (var1 instanceof SlotProvider) {
            SlotProvider var2 = (SlotProvider)var1;
            return var2.getSlotsFromRange(this.slotRange.slots());
        }
        return SlotCollection.EMPTY;
    }
}

