/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;

public interface SlotCollection {
    public static final SlotCollection EMPTY = Stream::empty;

    public Stream<ItemStack> itemCopies();

    default public SlotCollection filter(Predicate<ItemStack> var0) {
        return new Filtered(this, var0);
    }

    default public SlotCollection flatMap(Function<ItemStack, ? extends SlotCollection> var0) {
        return new FlatMapped(this, var0);
    }

    default public SlotCollection limit(int var0) {
        return new Limited(this, var0);
    }

    public static SlotCollection of(SlotAccess var0) {
        return () -> Stream.of(var0.get().copy());
    }

    public static SlotCollection of(Collection<? extends SlotAccess> var0) {
        return switch (var0.size()) {
            case 0 -> EMPTY;
            case 1 -> SlotCollection.of(var0.iterator().next());
            default -> () -> var0.stream().map(SlotAccess::get).map(ItemStack::copy);
        };
    }

    public static SlotCollection concat(SlotCollection var0, SlotCollection var1) {
        return () -> Stream.concat(var0.itemCopies(), var1.itemCopies());
    }

    public static SlotCollection concat(List<? extends SlotCollection> var0) {
        return switch (var0.size()) {
            case 0 -> EMPTY;
            case 1 -> var0.getFirst();
            case 2 -> SlotCollection.concat(var0.get(0), var0.get(1));
            default -> () -> var0.stream().flatMap(SlotCollection::itemCopies);
        };
    }

    public record Filtered(SlotCollection slots, Predicate<ItemStack> filter) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().filter(this.filter);
        }

        @Override
        public SlotCollection filter(Predicate<ItemStack> var0) {
            return new Filtered(this.slots, this.filter.and(var0));
        }
    }

    public record FlatMapped(SlotCollection slots, Function<ItemStack, ? extends SlotCollection> mapper) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().map(this.mapper).flatMap(SlotCollection::itemCopies);
        }
    }

    public record Limited(SlotCollection slots, int limit) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().limit(this.limit);
        }

        @Override
        public SlotCollection limit(int var0) {
            return new Limited(this.slots, Math.min(this.limit, var0));
        }
    }
}

