/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ItemCost(Holder<Item> item, int count, DataComponentExactPredicate components, ItemStack itemStack) {
    public static final Codec<ItemCost> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Item.CODEC.fieldOf("id").forGetter(ItemCost::item), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").orElse((Object)1).forGetter(ItemCost::count), (App)DataComponentExactPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentExactPredicate.EMPTY).forGetter(ItemCost::components)).apply((Applicative)var0, ItemCost::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemCost> STREAM_CODEC = StreamCodec.composite(Item.STREAM_CODEC, ItemCost::item, ByteBufCodecs.VAR_INT, ItemCost::count, DataComponentExactPredicate.STREAM_CODEC, ItemCost::components, ItemCost::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<ItemCost>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);

    public ItemCost(ItemLike var0) {
        this(var0, 1);
    }

    public ItemCost(ItemLike var0, int var1) {
        this(var0.asItem().builtInRegistryHolder(), var1, DataComponentExactPredicate.EMPTY);
    }

    public ItemCost(Holder<Item> var0, int var1, DataComponentExactPredicate var2) {
        this(var0, var1, var2, ItemCost.createStack(var0, var1, var2));
    }

    public ItemCost withComponents(UnaryOperator<DataComponentExactPredicate.Builder> var0) {
        return new ItemCost(this.item, this.count, ((DataComponentExactPredicate.Builder)var0.apply(DataComponentExactPredicate.builder())).build());
    }

    private static ItemStack createStack(Holder<Item> var0, int var1, DataComponentExactPredicate var2) {
        return new ItemStack(var0, var1, var2.asPatch());
    }

    public boolean test(ItemStack var0) {
        return var0.is(this.item) && this.components.test(var0);
    }
}

