/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Abilities;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public enum GameType implements StringRepresentable
{
    SURVIVAL(0, "survival"),
    CREATIVE(1, "creative"),
    ADVENTURE(2, "adventure"),
    SPECTATOR(3, "spectator");

    public static final GameType DEFAULT_MODE;
    public static final StringRepresentable.EnumCodec<GameType> CODEC;
    private static final IntFunction<GameType> BY_ID;
    public static final StreamCodec<ByteBuf, GameType> STREAM_CODEC;
    @Deprecated
    public static final Codec<GameType> LEGACY_ID_CODEC;
    private static final int NOT_SET = -1;
    private final int id;
    private final String name;
    private final Component shortName;
    private final Component longName;

    private GameType(int var2, String var3) {
        this.id = var2;
        this.name = var3;
        this.shortName = Component.translatable("selectWorld.gameMode." + var3);
        this.longName = Component.translatable("gameMode." + var3);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public Component getLongDisplayName() {
        return this.longName;
    }

    public Component getShortDisplayName() {
        return this.shortName;
    }

    public void updatePlayerAbilities(Abilities var0) {
        if (this == CREATIVE) {
            var0.mayfly = true;
            var0.instabuild = true;
            var0.invulnerable = true;
        } else if (this == SPECTATOR) {
            var0.mayfly = true;
            var0.instabuild = false;
            var0.invulnerable = true;
            var0.flying = true;
        } else {
            var0.mayfly = false;
            var0.instabuild = false;
            var0.invulnerable = false;
            var0.flying = false;
        }
        var0.mayBuild = !this.isBlockPlacingRestricted();
    }

    public boolean isBlockPlacingRestricted() {
        return this == ADVENTURE || this == SPECTATOR;
    }

    public boolean isCreative() {
        return this == CREATIVE;
    }

    public boolean isSurvival() {
        return this == SURVIVAL || this == ADVENTURE;
    }

    public static GameType byId(int var0) {
        return BY_ID.apply(var0);
    }

    public static GameType byName(String var0) {
        return GameType.byName(var0, SURVIVAL);
    }

    @Contract(value="_,!null->!null;_,null->_")
    public static @Nullable GameType byName(String var0, @Nullable GameType var1) {
        GameType var2 = CODEC.byName(var0);
        return var2 != null ? var2 : var1;
    }

    public static int getNullableId(@Nullable GameType var0) {
        return var0 != null ? var0.id : -1;
    }

    public static @Nullable GameType byNullableId(int var0) {
        if (var0 == -1) {
            return null;
        }
        return GameType.byId(var0);
    }

    public static boolean isValidId(int var0) {
        return Arrays.stream(GameType.values()).anyMatch(var1 -> var1.id == var0);
    }

    static {
        DEFAULT_MODE = SURVIVAL;
        CODEC = StringRepresentable.fromEnum(GameType::values);
        BY_ID = ByIdMap.continuous(GameType::getId, GameType.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, GameType::getId);
        LEGACY_ID_CODEC = Codec.INT.xmap(GameType::byId, GameType::getId);
    }
}

