/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public interface LevelHeightAccessor {
    public int getHeight();

    public int getMinY();

    default public int getMaxY() {
        return this.getMinY() + this.getHeight() - 1;
    }

    default public int getSectionsCount() {
        return this.getMaxSectionY() - this.getMinSectionY() + 1;
    }

    default public int getMinSectionY() {
        return SectionPos.blockToSectionCoord(this.getMinY());
    }

    default public int getMaxSectionY() {
        return SectionPos.blockToSectionCoord(this.getMaxY());
    }

    default public boolean isInsideBuildHeight(int var0) {
        return var0 >= this.getMinY() && var0 <= this.getMaxY();
    }

    default public boolean isOutsideBuildHeight(BlockPos var0) {
        return this.isOutsideBuildHeight(var0.getY());
    }

    default public boolean isOutsideBuildHeight(int var0) {
        return var0 < this.getMinY() || var0 > this.getMaxY();
    }

    default public int getSectionIndex(int var0) {
        return this.getSectionIndexFromSectionY(SectionPos.blockToSectionCoord(var0));
    }

    default public int getSectionIndexFromSectionY(int var0) {
        return var0 - this.getMinSectionY();
    }

    default public int getSectionYFromSectionIndex(int var0) {
        return var0 + this.getMinSectionY();
    }

    public static LevelHeightAccessor create(final int var0, final int var1) {
        return new LevelHeightAccessor(){

            @Override
            public int getHeight() {
                return var1;
            }

            @Override
            public int getMinY() {
                return var0;
            }
        };
    }
}

