/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;

public class LocalMobCapCalculator {
    private final Long2ObjectMap<List<ServerPlayer>> playersNearChunk = new Long2ObjectOpenHashMap();
    private final Map<ServerPlayer, MobCounts> playerMobCounts = Maps.newHashMap();
    private final ChunkMap chunkMap;

    public LocalMobCapCalculator(ChunkMap var0) {
        this.chunkMap = var0;
    }

    private List<ServerPlayer> getPlayersNear(ChunkPos var0) {
        return (List)this.playersNearChunk.computeIfAbsent(var0.toLong(), var1 -> this.chunkMap.getPlayersCloseForSpawning(var0));
    }

    public void addMob(ChunkPos var02, MobCategory var1) {
        for (ServerPlayer var3 : this.getPlayersNear(var02)) {
            this.playerMobCounts.computeIfAbsent(var3, var0 -> new MobCounts()).add(var1);
        }
    }

    public boolean canSpawn(MobCategory var0, ChunkPos var1) {
        for (ServerPlayer var3 : this.getPlayersNear(var1)) {
            MobCounts var4 = this.playerMobCounts.get(var3);
            if (var4 != null && !var4.canSpawn(var0)) continue;
            return true;
        }
        return false;
    }

    static class MobCounts {
        private final Object2IntMap<MobCategory> counts = new Object2IntOpenHashMap(MobCategory.values().length);

        MobCounts() {
        }

        public void add(MobCategory var02) {
            this.counts.computeInt((Object)var02, (var0, var1) -> var1 == null ? 1 : var1 + 1);
        }

        public boolean canSpawn(MobCategory var0) {
            return this.counts.getOrDefault((Object)var0, 0) < var0.getMaxInstancesPerChunk();
        }
    }
}

