/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.LightLayer;

public record SpawnData(CompoundTag entityToSpawn, Optional<CustomSpawnRules> customSpawnRules, Optional<EquipmentTable> equipment) {
    public static final String ENTITY_TAG = "entity";
    public static final Codec<SpawnData> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)CompoundTag.CODEC.fieldOf(ENTITY_TAG).forGetter(var0 -> var0.entityToSpawn), (App)CustomSpawnRules.CODEC.optionalFieldOf("custom_spawn_rules").forGetter(var0 -> var0.customSpawnRules), (App)EquipmentTable.CODEC.optionalFieldOf("equipment").forGetter(var0 -> var0.equipment)).apply((Applicative)var02, SpawnData::new));
    public static final Codec<WeightedList<SpawnData>> LIST_CODEC = WeightedList.codec(CODEC);

    public SpawnData() {
        this(new CompoundTag(), Optional.empty(), Optional.empty());
    }

    public SpawnData {
        Optional<Identifier> var3 = var0.read("id", Identifier.CODEC);
        if (var3.isPresent()) {
            var0.store("id", Identifier.CODEC, var3.get());
        } else {
            var0.remove("id");
        }
    }

    public CompoundTag getEntityToSpawn() {
        return this.entityToSpawn;
    }

    public Optional<CustomSpawnRules> getCustomSpawnRules() {
        return this.customSpawnRules;
    }

    public Optional<EquipmentTable> getEquipment() {
        return this.equipment;
    }

    public record CustomSpawnRules(InclusiveRange<Integer> blockLightLimit, InclusiveRange<Integer> skyLightLimit) {
        private static final InclusiveRange<Integer> LIGHT_RANGE = new InclusiveRange<Integer>(0, 15);
        public static final Codec<CustomSpawnRules> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)CustomSpawnRules.lightLimit("block_light_limit").forGetter(var0 -> var0.blockLightLimit), (App)CustomSpawnRules.lightLimit("sky_light_limit").forGetter(var0 -> var0.skyLightLimit)).apply((Applicative)var02, CustomSpawnRules::new));

        private static DataResult<InclusiveRange<Integer>> checkLightBoundaries(InclusiveRange<Integer> var0) {
            if (!LIGHT_RANGE.contains(var0)) {
                return DataResult.error(() -> "Light values must be withing range " + String.valueOf(LIGHT_RANGE));
            }
            return DataResult.success(var0);
        }

        private static MapCodec<InclusiveRange<Integer>> lightLimit(String var0) {
            return InclusiveRange.INT.lenientOptionalFieldOf(var0, LIGHT_RANGE).validate(CustomSpawnRules::checkLightBoundaries);
        }

        public boolean isValidPosition(BlockPos var0, ServerLevel var1) {
            return this.blockLightLimit.isValueInRange(var1.getBrightness(LightLayer.BLOCK, var0)) && this.skyLightLimit.isValueInRange(var1.getBrightness(LightLayer.SKY, var0));
        }
    }
}

