/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.level.DryFoliageColor;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public final class Biome {
    public static final Codec<Biome> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ClimateSettings.CODEC.forGetter(var0 -> var0.climateSettings), (App)EnvironmentAttributeMap.CODEC_ONLY_POSITIONAL.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.EMPTY).forGetter(var0 -> var0.attributes), (App)BiomeSpecialEffects.CODEC.fieldOf("effects").forGetter(var0 -> var0.specialEffects), (App)BiomeGenerationSettings.CODEC.forGetter(var0 -> var0.generationSettings), (App)MobSpawnSettings.CODEC.forGetter(var0 -> var0.mobSettings)).apply((Applicative)var02, Biome::new));
    public static final Codec<Biome> NETWORK_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ClimateSettings.CODEC.forGetter(var0 -> var0.climateSettings), (App)EnvironmentAttributeMap.NETWORK_CODEC.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.EMPTY).forGetter(var0 -> var0.attributes), (App)BiomeSpecialEffects.CODEC.fieldOf("effects").forGetter(var0 -> var0.specialEffects)).apply((Applicative)var02, (var0, var1, var2) -> new Biome((ClimateSettings)var0, (EnvironmentAttributeMap)var1, (BiomeSpecialEffects)var2, BiomeGenerationSettings.EMPTY, MobSpawnSettings.EMPTY)));
    public static final Codec<Holder<Biome>> CODEC = RegistryFileCodec.create(Registries.BIOME, DIRECT_CODEC);
    public static final Codec<HolderSet<Biome>> LIST_CODEC = RegistryCodecs.homogeneousList(Registries.BIOME, DIRECT_CODEC);
    private static final PerlinSimplexNoise TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final PerlinSimplexNoise FROZEN_TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final PerlinSimplexNoise BIOME_INFO_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int TEMPERATURE_CACHE_SIZE = 1024;
    public final ClimateSettings climateSettings;
    private final BiomeGenerationSettings generationSettings;
    private final MobSpawnSettings mobSettings;
    private final EnvironmentAttributeMap attributes;
    private final BiomeSpecialEffects specialEffects;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> temperatureCache = ThreadLocal.withInitial(() -> {
        Long2FloatLinkedOpenHashMap var0 = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue(Float.NaN);
        return var0;
    });

    Biome(ClimateSettings var0, EnvironmentAttributeMap var1, BiomeSpecialEffects var2, BiomeGenerationSettings var3, MobSpawnSettings var4) {
        this.climateSettings = var0;
        this.generationSettings = var3;
        this.mobSettings = var4;
        this.attributes = var1;
        this.specialEffects = var2;
    }

    public MobSpawnSettings getMobSettings() {
        return this.mobSettings;
    }

    public boolean hasPrecipitation() {
        return this.climateSettings.hasPrecipitation();
    }

    public Precipitation getPrecipitationAt(BlockPos var0, int var1) {
        if (!this.hasPrecipitation()) {
            return Precipitation.NONE;
        }
        return this.coldEnoughToSnow(var0, var1) ? Precipitation.SNOW : Precipitation.RAIN;
    }

    private float getHeightAdjustedTemperature(BlockPos var0, int var1) {
        float var2 = this.climateSettings.temperatureModifier.modifyTemperature(var0, this.getBaseTemperature());
        int var3 = var1 + 17;
        if (var0.getY() > var3) {
            float var4 = (float)(TEMPERATURE_NOISE.getValue((float)var0.getX() / 8.0f, (float)var0.getZ() / 8.0f, false) * 8.0);
            return var2 - (var4 + (float)var0.getY() - (float)var3) * 0.05f / 40.0f;
        }
        return var2;
    }

    @Deprecated
    public float getTemperature(BlockPos var0, int var1) {
        long var2 = var0.asLong();
        Long2FloatLinkedOpenHashMap var4 = this.temperatureCache.get();
        float var5 = var4.get(var2);
        if (!Float.isNaN(var5)) {
            return var5;
        }
        float var6 = this.getHeightAdjustedTemperature(var0, var1);
        if (var4.size() == 1024) {
            var4.removeFirstFloat();
        }
        var4.put(var2, var6);
        return var6;
    }

    public boolean shouldFreeze(LevelReader var0, BlockPos var1) {
        return this.shouldFreeze(var0, var1, true);
    }

    public boolean shouldFreeze(LevelReader var0, BlockPos var1, boolean var2) {
        if (this.warmEnoughToRain(var1, var0.getSeaLevel())) {
            return false;
        }
        if (var0.isInsideBuildHeight(var1.getY()) && var0.getBrightness(LightLayer.BLOCK, var1) < 10) {
            BlockState var3 = var0.getBlockState(var1);
            FluidState var4 = var0.getFluidState(var1);
            if (var4.getType() == Fluids.WATER && var3.getBlock() instanceof LiquidBlock) {
                boolean var5;
                if (!var2) {
                    return true;
                }
                boolean bl = var5 = var0.isWaterAt(var1.west()) && var0.isWaterAt(var1.east()) && var0.isWaterAt(var1.north()) && var0.isWaterAt(var1.south());
                if (!var5) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean coldEnoughToSnow(BlockPos var0, int var1) {
        return !this.warmEnoughToRain(var0, var1);
    }

    public boolean warmEnoughToRain(BlockPos var0, int var1) {
        return this.getTemperature(var0, var1) >= 0.15f;
    }

    public boolean shouldMeltFrozenOceanIcebergSlightly(BlockPos var0, int var1) {
        return this.getTemperature(var0, var1) > 0.1f;
    }

    public boolean shouldSnow(LevelReader var0, BlockPos var1) {
        BlockState var2;
        if (this.getPrecipitationAt(var1, var0.getSeaLevel()) != Precipitation.SNOW) {
            return false;
        }
        return var0.isInsideBuildHeight(var1.getY()) && var0.getBrightness(LightLayer.BLOCK, var1) < 10 && ((var2 = var0.getBlockState(var1)).isAir() || var2.is(Blocks.SNOW)) && Blocks.SNOW.defaultBlockState().canSurvive(var0, var1);
    }

    public BiomeGenerationSettings getGenerationSettings() {
        return this.generationSettings;
    }

    public int getGrassColor(double var0, double var2) {
        int var4 = this.getBaseGrassColor();
        return this.specialEffects.grassColorModifier().modifyColor(var0, var2, var4);
    }

    private int getBaseGrassColor() {
        Optional<Integer> var0 = this.specialEffects.grassColorOverride();
        if (var0.isPresent()) {
            return var0.get();
        }
        return this.getGrassColorFromTexture();
    }

    private int getGrassColorFromTexture() {
        double var0 = Mth.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = Mth.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return GrassColor.get(var0, var2);
    }

    public int getFoliageColor() {
        return this.specialEffects.foliageColorOverride().orElseGet(this::getFoliageColorFromTexture);
    }

    private int getFoliageColorFromTexture() {
        double var0 = Mth.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = Mth.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return FoliageColor.get(var0, var2);
    }

    public int getDryFoliageColor() {
        return this.specialEffects.dryFoliageColorOverride().orElseGet(this::getDryFoliageColorFromTexture);
    }

    private int getDryFoliageColorFromTexture() {
        double var0 = Mth.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = Mth.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return DryFoliageColor.get(var0, var2);
    }

    public float getBaseTemperature() {
        return this.climateSettings.temperature;
    }

    public EnvironmentAttributeMap getAttributes() {
        return this.attributes;
    }

    public BiomeSpecialEffects getSpecialEffects() {
        return this.specialEffects;
    }

    public int getWaterColor() {
        return this.specialEffects.waterColor();
    }

    public static final class ClimateSettings
    extends Record {
        private final boolean hasPrecipitation;
        final float temperature;
        final TemperatureModifier temperatureModifier;
        final float downfall;
        public static final MapCodec<ClimateSettings> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(var0 -> var0.hasPrecipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(var0 -> Float.valueOf(var0.temperature)), (App)TemperatureModifier.CODEC.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(var0 -> var0.temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(var0 -> Float.valueOf(var0.downfall))).apply((Applicative)var02, ClimateSettings::new));

        ClimateSettings(boolean var0, float var1, TemperatureModifier var2, float var3) {
            this.hasPrecipitation = var0;
            this.temperature = var1;
            this.temperatureModifier = var2;
            this.downfall = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "hasPrecipitation", "temperature", "temperatureModifier", "downfall"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "hasPrecipitation", "temperature", "temperatureModifier", "downfall"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "hasPrecipitation", "temperature", "temperatureModifier", "downfall"}, this, var0);
        }

        public boolean hasPrecipitation() {
            return this.hasPrecipitation;
        }

        public float temperature() {
            return this.temperature;
        }

        public TemperatureModifier temperatureModifier() {
            return this.temperatureModifier;
        }

        public float downfall() {
            return this.downfall;
        }
    }

    public static enum Precipitation implements StringRepresentable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<Precipitation> CODEC;
        private final String name;

        private Precipitation(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Precipitation::values);
        }
    }

    public static enum TemperatureModifier implements StringRepresentable
    {
        NONE("none"){

            @Override
            public float modifyTemperature(BlockPos var0, float var1) {
                return var1;
            }
        }
        ,
        FROZEN("frozen"){

            @Override
            public float modifyTemperature(BlockPos var0, float var1) {
                double var8;
                double var4;
                double var2 = FROZEN_TEMPERATURE_NOISE.getValue((double)var0.getX() * 0.05, (double)var0.getZ() * 0.05, false) * 7.0;
                double var6 = var2 + (var4 = BIOME_INFO_NOISE.getValue((double)var0.getX() * 0.2, (double)var0.getZ() * 0.2, false));
                if (var6 < 0.3 && (var8 = BIOME_INFO_NOISE.getValue((double)var0.getX() * 0.09, (double)var0.getZ() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return var1;
            }
        };

        private final String name;
        public static final Codec<TemperatureModifier> CODEC;

        public abstract float modifyTemperature(BlockPos var1, float var2);

        TemperatureModifier(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TemperatureModifier::values);
        }
    }

    public static class BiomeBuilder {
        private boolean hasPrecipitation = true;
        private @Nullable Float temperature;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;
        private @Nullable Float downfall;
        private final EnvironmentAttributeMap.Builder attributes = EnvironmentAttributeMap.builder();
        private @Nullable BiomeSpecialEffects specialEffects;
        private @Nullable MobSpawnSettings mobSpawnSettings;
        private @Nullable BiomeGenerationSettings generationSettings;

        public BiomeBuilder hasPrecipitation(boolean var0) {
            this.hasPrecipitation = var0;
            return this;
        }

        public BiomeBuilder temperature(float var0) {
            this.temperature = Float.valueOf(var0);
            return this;
        }

        public BiomeBuilder downfall(float var0) {
            this.downfall = Float.valueOf(var0);
            return this;
        }

        public BiomeBuilder putAttributes(EnvironmentAttributeMap var0) {
            this.attributes.putAll(var0);
            return this;
        }

        public BiomeBuilder putAttributes(EnvironmentAttributeMap.Builder var0) {
            return this.putAttributes(var0.build());
        }

        public <Value> BiomeBuilder setAttribute(EnvironmentAttribute<Value> var0, Value var1) {
            this.attributes.set(var0, var1);
            return this;
        }

        public <Value, Parameter> BiomeBuilder modifyAttribute(EnvironmentAttribute<Value> var0, AttributeModifier<Value, Parameter> var1, Parameter var2) {
            this.attributes.modify(var0, var1, var2);
            return this;
        }

        public BiomeBuilder specialEffects(BiomeSpecialEffects var0) {
            this.specialEffects = var0;
            return this;
        }

        public BiomeBuilder mobSpawnSettings(MobSpawnSettings var0) {
            this.mobSpawnSettings = var0;
            return this;
        }

        public BiomeBuilder generationSettings(BiomeGenerationSettings var0) {
            this.generationSettings = var0;
            return this;
        }

        public BiomeBuilder temperatureAdjustment(TemperatureModifier var0) {
            this.temperatureModifier = var0;
            return this;
        }

        public Biome build() {
            if (this.temperature == null || this.downfall == null || this.specialEffects == null || this.mobSpawnSettings == null || this.generationSettings == null) {
                throw new IllegalStateException("You are missing parameters to build a proper biome\n" + String.valueOf(this));
            }
            return new Biome(new ClimateSettings(this.hasPrecipitation, this.temperature.floatValue(), this.temperatureModifier, this.downfall.floatValue()), this.attributes.build(), this.specialEffects, this.generationSettings, this.mobSpawnSettings);
        }

        public String toString() {
            return "BiomeBuilder{\nhasPrecipitation=" + this.hasPrecipitation + ",\ntemperature=" + this.temperature + ",\ntemperatureModifier=" + String.valueOf(this.temperatureModifier) + ",\ndownfall=" + this.downfall + ",\nspecialEffects=" + String.valueOf(this.specialEffects) + ",\nmobSpawnSettings=" + String.valueOf(this.mobSpawnSettings) + ",\ngenerationSettings=" + String.valueOf(this.generationSettings) + ",\n}";
        }
    }
}

