/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import org.jspecify.annotations.Nullable;

public class Climate {
    private static final boolean DEBUG_SLOW_BIOME_SEARCH = false;
    private static final float QUANTIZATION_FACTOR = 10000.0f;
    @VisibleForTesting
    protected static final int PARAMETER_COUNT = 7;

    public static TargetPoint target(float var0, float var1, float var2, float var3, float var4, float var5) {
        return new TargetPoint(Climate.quantizeCoord(var0), Climate.quantizeCoord(var1), Climate.quantizeCoord(var2), Climate.quantizeCoord(var3), Climate.quantizeCoord(var4), Climate.quantizeCoord(var5));
    }

    public static ParameterPoint parameters(float var0, float var1, float var2, float var3, float var4, float var5, float var6) {
        return new ParameterPoint(Parameter.point(var0), Parameter.point(var1), Parameter.point(var2), Parameter.point(var3), Parameter.point(var4), Parameter.point(var5), Climate.quantizeCoord(var6));
    }

    public static ParameterPoint parameters(Parameter var0, Parameter var1, Parameter var2, Parameter var3, Parameter var4, Parameter var5, float var6) {
        return new ParameterPoint(var0, var1, var2, var3, var4, var5, Climate.quantizeCoord(var6));
    }

    public static long quantizeCoord(float var0) {
        return (long)(var0 * 10000.0f);
    }

    public static float unquantizeCoord(long var0) {
        return (float)var0 / 10000.0f;
    }

    public static Sampler empty() {
        DensityFunction var0 = DensityFunctions.zero();
        return new Sampler(var0, var0, var0, var0, var0, var0, List.of());
    }

    public static BlockPos findSpawnPosition(List<ParameterPoint> var0, Sampler var1) {
        return new SpawnFinder(var0, (Sampler)var1).result.location();
    }

    public static final class TargetPoint
    extends Record {
        final long temperature;
        final long humidity;
        final long continentalness;
        final long erosion;
        final long depth;
        final long weirdness;

        public TargetPoint(long var0, long var2, long var4, long var6, long var8, long var10) {
            this.temperature = var0;
            this.humidity = var2;
            this.continentalness = var4;
            this.erosion = var6;
            this.depth = var8;
            this.weirdness = var10;
        }

        @VisibleForTesting
        protected long[] toParameterArray() {
            return new long[]{this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L};
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TargetPoint.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "temperature", "humidity", "continentalness", "erosion", "depth", "weirdness"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TargetPoint.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "temperature", "humidity", "continentalness", "erosion", "depth", "weirdness"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TargetPoint.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "temperature", "humidity", "continentalness", "erosion", "depth", "weirdness"}, this, var0);
        }

        public long temperature() {
            return this.temperature;
        }

        public long humidity() {
            return this.humidity;
        }

        public long continentalness() {
            return this.continentalness;
        }

        public long erosion() {
            return this.erosion;
        }

        public long depth() {
            return this.depth;
        }

        public long weirdness() {
            return this.weirdness;
        }
    }

    public record ParameterPoint(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, long offset) {
        public static final Codec<ParameterPoint> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Parameter.CODEC.fieldOf("temperature").forGetter(var0 -> var0.temperature), (App)Parameter.CODEC.fieldOf("humidity").forGetter(var0 -> var0.humidity), (App)Parameter.CODEC.fieldOf("continentalness").forGetter(var0 -> var0.continentalness), (App)Parameter.CODEC.fieldOf("erosion").forGetter(var0 -> var0.erosion), (App)Parameter.CODEC.fieldOf("depth").forGetter(var0 -> var0.depth), (App)Parameter.CODEC.fieldOf("weirdness").forGetter(var0 -> var0.weirdness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::quantizeCoord, Climate::unquantizeCoord).forGetter(var0 -> var0.offset)).apply((Applicative)var02, ParameterPoint::new));

        long fitness(TargetPoint var0) {
            return Mth.square(this.temperature.distance(var0.temperature)) + Mth.square(this.humidity.distance(var0.humidity)) + Mth.square(this.continentalness.distance(var0.continentalness)) + Mth.square(this.erosion.distance(var0.erosion)) + Mth.square(this.depth.distance(var0.depth)) + Mth.square(this.weirdness.distance(var0.weirdness)) + Mth.square(this.offset);
        }

        protected List<Parameter> parameterSpace() {
            return ImmutableList.of((Object)this.temperature, (Object)this.humidity, (Object)this.continentalness, (Object)this.erosion, (Object)this.depth, (Object)this.weirdness, (Object)new Parameter(this.offset, this.offset));
        }
    }

    public record Parameter(long min, long max) {
        public static final Codec<Parameter> CODEC = ExtraCodecs.intervalCodec(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (var0, var1) -> {
            if (var0.compareTo((Float)var1) > 0) {
                return DataResult.error(() -> "Cannon construct interval, min > max (" + var0 + " > " + var1 + ")");
            }
            return DataResult.success((Object)new Parameter(Climate.quantizeCoord(var0.floatValue()), Climate.quantizeCoord(var1.floatValue())));
        }, var0 -> Float.valueOf(Climate.unquantizeCoord(var0.min())), var0 -> Float.valueOf(Climate.unquantizeCoord(var0.max())));

        public static Parameter point(float var0) {
            return Parameter.span(var0, var0);
        }

        public static Parameter span(float var0, float var1) {
            if (var0 > var1) {
                throw new IllegalArgumentException("min > max: " + var0 + " " + var1);
            }
            return new Parameter(Climate.quantizeCoord(var0), Climate.quantizeCoord(var1));
        }

        public static Parameter span(Parameter var0, Parameter var1) {
            if (var0.min() > var1.max()) {
                throw new IllegalArgumentException("min > max: " + String.valueOf(var0) + " " + String.valueOf(var1));
            }
            return new Parameter(var0.min(), var1.max());
        }

        @Override
        public String toString() {
            return this.min == this.max ? String.format(Locale.ROOT, "%d", this.min) : String.format(Locale.ROOT, "[%d-%d]", this.min, this.max);
        }

        public long distance(long var0) {
            long var2 = var0 - this.max;
            long var4 = this.min - var0;
            if (var2 > 0L) {
                return var2;
            }
            return Math.max(var4, 0L);
        }

        public long distance(Parameter var0) {
            long var1 = var0.min() - this.max;
            long var3 = this.min - var0.max();
            if (var1 > 0L) {
                return var1;
            }
            return Math.max(var3, 0L);
        }

        public Parameter span(@Nullable Parameter var0) {
            return var0 == null ? this : new Parameter(Math.min(this.min, var0.min()), Math.max(this.max, var0.max()));
        }
    }

    public record Sampler(DensityFunction temperature, DensityFunction humidity, DensityFunction continentalness, DensityFunction erosion, DensityFunction depth, DensityFunction weirdness, List<ParameterPoint> spawnTarget) {
        public TargetPoint sample(int var0, int var1, int var2) {
            int var3 = QuartPos.toBlock(var0);
            int var4 = QuartPos.toBlock(var1);
            int var5 = QuartPos.toBlock(var2);
            DensityFunction.SinglePointContext var6 = new DensityFunction.SinglePointContext(var3, var4, var5);
            return Climate.target((float)this.temperature.compute(var6), (float)this.humidity.compute(var6), (float)this.continentalness.compute(var6), (float)this.erosion.compute(var6), (float)this.depth.compute(var6), (float)this.weirdness.compute(var6));
        }

        public BlockPos findSpawnPosition() {
            if (this.spawnTarget.isEmpty()) {
                return BlockPos.ZERO;
            }
            return Climate.findSpawnPosition(this.spawnTarget, this);
        }
    }

    static class SpawnFinder {
        private static final long MAX_RADIUS = 2048L;
        Result result;

        SpawnFinder(List<ParameterPoint> var0, Sampler var1) {
            this.result = SpawnFinder.getSpawnPositionAndFitness(var0, var1, 0, 0);
            this.radialSearch(var0, var1, 2048.0f, 512.0f);
            this.radialSearch(var0, var1, 512.0f, 32.0f);
        }

        private void radialSearch(List<ParameterPoint> var0, Sampler var1, float var2, float var3) {
            float var4 = 0.0f;
            float var5 = var3;
            BlockPos var6 = this.result.location();
            while (var5 <= var2) {
                int var8;
                int var7 = var6.getX() + (int)(Math.sin(var4) * (double)var5);
                Result var9 = SpawnFinder.getSpawnPositionAndFitness(var0, var1, var7, var8 = var6.getZ() + (int)(Math.cos(var4) * (double)var5));
                if (var9.fitness() < this.result.fitness()) {
                    this.result = var9;
                }
                if (!((double)(var4 += var3 / var5) > Math.PI * 2)) continue;
                var4 = 0.0f;
                var5 += var3;
            }
        }

        private static Result getSpawnPositionAndFitness(List<ParameterPoint> var0, Sampler var1, int var2, int var3) {
            TargetPoint var4 = var1.sample(QuartPos.fromBlock(var2), 0, QuartPos.fromBlock(var3));
            TargetPoint var5 = new TargetPoint(var4.temperature(), var4.humidity(), var4.continentalness(), var4.erosion(), 0L, var4.weirdness());
            long var6 = Long.MAX_VALUE;
            for (ParameterPoint var9 : var0) {
                var6 = Math.min(var6, var9.fitness(var5));
            }
            long var8 = Mth.square((long)var2) + Mth.square((long)var3);
            long var10 = var6 * Mth.square(2048L) + var8;
            return new Result(new BlockPos(var2, 0, var3), var10);
        }

        record Result(BlockPos location, long fitness) {
        }
    }

    public static class ParameterList<T> {
        private final List<Pair<ParameterPoint, T>> values;
        private final RTree<T> index;

        public static <T> Codec<ParameterList<T>> codec(MapCodec<T> var0) {
            return ExtraCodecs.nonEmptyList(RecordCodecBuilder.create(var1 -> var1.group((App)ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)var0.forGetter(Pair::getSecond)).apply((Applicative)var1, Pair::of)).listOf()).xmap(ParameterList::new, ParameterList::values);
        }

        public ParameterList(List<Pair<ParameterPoint, T>> var0) {
            this.values = var0;
            this.index = RTree.create(var0);
        }

        public List<Pair<ParameterPoint, T>> values() {
            return this.values;
        }

        public T findValue(TargetPoint var0) {
            return this.findValueIndex(var0);
        }

        @VisibleForTesting
        public T findValueBruteForce(TargetPoint var0) {
            Iterator<Pair<ParameterPoint, T>> var1 = this.values().iterator();
            Pair<ParameterPoint, T> var2 = var1.next();
            long var3 = ((ParameterPoint)var2.getFirst()).fitness(var0);
            Object var5 = var2.getSecond();
            while (var1.hasNext()) {
                Pair<ParameterPoint, T> var6 = var1.next();
                long var7 = ((ParameterPoint)var6.getFirst()).fitness(var0);
                if (var7 >= var3) continue;
                var3 = var7;
                var5 = var6.getSecond();
            }
            return (T)var5;
        }

        public T findValueIndex(TargetPoint var0) {
            return this.findValueIndex(var0, RTree.Node::distance);
        }

        protected T findValueIndex(TargetPoint var0, DistanceMetric<T> var1) {
            return this.index.search(var0, var1);
        }
    }

    protected static final class RTree<T> {
        private static final int CHILDREN_PER_NODE = 6;
        private final Node<T> root;
        private final ThreadLocal<@Nullable Leaf<T>> lastResult = new ThreadLocal();

        private RTree(Node<T> var0) {
            this.root = var0;
        }

        public static <T> RTree<T> create(List<Pair<ParameterPoint, T>> var02) {
            if (var02.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int var1 = ((ParameterPoint)var02.get(0).getFirst()).parameterSpace().size();
            if (var1 != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + var1);
            }
            List var2 = var02.stream().map(var0 -> new Leaf<Object>((ParameterPoint)var0.getFirst(), var0.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new RTree<T>(RTree.build(var1, var2));
        }

        private static <T> Node<T> build(int var0, List<? extends Node<T>> var12) {
            if (var12.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (var12.size() == 1) {
                return var12.get(0);
            }
            if (var12.size() <= 6) {
                var12.sort(Comparator.comparingLong(var1 -> {
                    long var2 = 0L;
                    for (int var4 = 0; var4 < var0; ++var4) {
                        Parameter var5 = var1.parameterSpace[var4];
                        var2 += Math.abs((var5.min() + var5.max()) / 2L);
                    }
                    return var2;
                }));
                return new SubTree(var12);
            }
            long var2 = Long.MAX_VALUE;
            int var4 = -1;
            List<SubTree<T>> var5 = null;
            for (int var6 = 0; var6 < var0; ++var6) {
                RTree.sort(var12, var0, var6, false);
                List<SubTree<T>> var7 = RTree.bucketize(var12);
                long var8 = 0L;
                for (SubTree<T> var11 : var7) {
                    var8 += RTree.cost(var11.parameterSpace);
                }
                if (var2 <= var8) continue;
                var2 = var8;
                var4 = var6;
                var5 = var7;
            }
            RTree.sort(var5, var0, var4, true);
            return new SubTree(var5.stream().map(var1 -> RTree.build(var0, Arrays.asList(var1.children))).collect(Collectors.toList()));
        }

        private static <T> void sort(List<? extends Node<T>> var0, int var1, int var2, boolean var3) {
            Comparator<Node<Node<T>>> var4 = RTree.comparator(var2, var3);
            for (int var5 = 1; var5 < var1; ++var5) {
                var4 = var4.thenComparing(RTree.comparator((var2 + var5) % var1, var3));
            }
            var0.sort(var4);
        }

        private static <T> Comparator<Node<T>> comparator(int var0, boolean var1) {
            return Comparator.comparingLong(var2 -> {
                Parameter var3 = var2.parameterSpace[var0];
                long var4 = (var3.min() + var3.max()) / 2L;
                return var1 ? Math.abs(var4) : var4;
            });
        }

        private static <T> List<SubTree<T>> bucketize(List<? extends Node<T>> var0) {
            ArrayList var1 = Lists.newArrayList();
            ArrayList var2 = Lists.newArrayList();
            int var3 = (int)Math.pow(6.0, Math.floor(Math.log((double)var0.size() - 0.01) / Math.log(6.0)));
            for (Node<T> var5 : var0) {
                var2.add(var5);
                if (var2.size() < var3) continue;
                var1.add(new SubTree(var2));
                var2 = Lists.newArrayList();
            }
            if (!var2.isEmpty()) {
                var1.add(new SubTree(var2));
            }
            return var1;
        }

        private static long cost(Parameter[] var0) {
            long var1 = 0L;
            for (Parameter var6 : var0) {
                var1 += Math.abs(var6.max() - var6.min());
            }
            return var1;
        }

        static <T> List<Parameter> buildParameterSpace(List<? extends Node<T>> var0) {
            if (var0.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int var1 = 7;
            ArrayList var2 = Lists.newArrayList();
            for (int var3 = 0; var3 < 7; ++var3) {
                var2.add(null);
            }
            for (Node<T> var4 : var0) {
                for (int var5 = 0; var5 < 7; ++var5) {
                    var2.set(var5, var4.parameterSpace[var5].span((Parameter)var2.get(var5)));
                }
            }
            return var2;
        }

        public T search(TargetPoint var0, DistanceMetric<T> var1) {
            long[] var2 = var0.toParameterArray();
            Leaf<T> var3 = this.root.search(var2, this.lastResult.get(), var1);
            this.lastResult.set(var3);
            return var3.value;
        }

        static abstract class Node<T> {
            protected final Parameter[] parameterSpace;

            protected Node(List<Parameter> var0) {
                this.parameterSpace = var0.toArray(new Parameter[0]);
            }

            protected abstract Leaf<T> search(long[] var1, @Nullable Leaf<T> var2, DistanceMetric<T> var3);

            protected long distance(long[] var0) {
                long var1 = 0L;
                for (int var3 = 0; var3 < 7; ++var3) {
                    var1 += Mth.square(this.parameterSpace[var3].distance(var0[var3]));
                }
                return var1;
            }

            public String toString() {
                return Arrays.toString(this.parameterSpace);
            }
        }

        static final class SubTree<T>
        extends Node<T> {
            final Node<T>[] children;

            protected SubTree(List<? extends Node<T>> var0) {
                this(RTree.buildParameterSpace(var0), var0);
            }

            protected SubTree(List<Parameter> var0, List<? extends Node<T>> var1) {
                super(var0);
                this.children = var1.toArray(new Node[0]);
            }

            @Override
            protected Leaf<T> search(long[] var0, @Nullable Leaf<T> var1, DistanceMetric<T> var2) {
                long var3 = var1 == null ? Long.MAX_VALUE : var2.distance(var1, var0);
                Leaf<T> var5 = var1;
                for (Node<T> var9 : this.children) {
                    long var13;
                    long var10 = var2.distance(var9, var0);
                    if (var3 <= var10) continue;
                    Leaf<T> var12 = var9.search(var0, var5, var2);
                    long l = var13 = var9 == var12 ? var10 : var2.distance(var12, var0);
                    if (var3 <= var13) continue;
                    var3 = var13;
                    var5 = var12;
                }
                return var5;
            }
        }

        static final class Leaf<T>
        extends Node<T> {
            final T value;

            Leaf(ParameterPoint var0, T var1) {
                super(var0.parameterSpace());
                this.value = var1;
            }

            @Override
            protected Leaf<T> search(long[] var0, @Nullable Leaf<T> var1, DistanceMetric<T> var2) {
                return this;
            }
        }
    }

    static interface DistanceMetric<T> {
        public long distance(RTree.Node<T> var1, long[] var2);
    }
}

