/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Block
extends BlockBehaviour
implements ItemLike {
    public static final MapCodec<Block> CODEC = Block.simpleCodec(Block::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Holder.Reference<Block> builtInRegistryHolder = BuiltInRegistries.BLOCK.createIntrusiveHolder(this);
    public static final IdMapper<BlockState> BLOCK_STATE_REGISTRY = new IdMapper();
    private static final LoadingCache<VoxelShape, Boolean> SHAPE_FULL_BLOCK_CACHE = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape voxelshape) {
            return !Shapes.joinIsNotEmpty(Shapes.block(), voxelshape, BooleanOp.NOT_SAME);
        }
    });
    public static final int UPDATE_NEIGHBORS = 1;
    public static final int UPDATE_CLIENTS = 2;
    public static final int UPDATE_INVISIBLE = 4;
    public static final int UPDATE_IMMEDIATE = 8;
    public static final int UPDATE_KNOWN_SHAPE = 16;
    public static final int UPDATE_SUPPRESS_DROPS = 32;
    public static final int UPDATE_MOVE_BY_PISTON = 64;
    public static final int UPDATE_SKIP_SHAPE_UPDATE_ON_WIRE = 128;
    public static final int UPDATE_SKIP_BLOCK_ENTITY_SIDEEFFECTS = 256;
    public static final int UPDATE_SKIP_ON_PLACE = 512;
    @UpdateFlags
    public static final int UPDATE_NONE = 260;
    @UpdateFlags
    public static final int UPDATE_ALL = 3;
    @UpdateFlags
    public static final int UPDATE_ALL_IMMEDIATE = 11;
    @UpdateFlags
    public static final int UPDATE_SKIP_ALL_SIDEEFFECTS = 816;
    public static final float INDESTRUCTIBLE = -1.0f;
    public static final float INSTANT = 0.0f;
    public static final int UPDATE_LIMIT = 512;
    protected final StateDefinition<Block, BlockState> stateDefinition;
    private BlockState defaultBlockState;
    private @Nullable Item item;
    private static final int CACHE_SIZE = 256;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<ShapePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<ShapePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<ShapePairKey>(256, 0.25f){

            protected void rehash(int i) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    @Override
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public static int getId(@Nullable BlockState iblockdata) {
        if (iblockdata == null) {
            return 0;
        }
        int i = BLOCK_STATE_REGISTRY.getId(iblockdata);
        return i == -1 ? 0 : i;
    }

    public static BlockState stateById(int i) {
        BlockState iblockdata = BLOCK_STATE_REGISTRY.byId(i);
        return iblockdata == null ? Blocks.AIR.defaultBlockState() : iblockdata;
    }

    public static Block byItem(@Nullable Item item) {
        return item instanceof BlockItem ? ((BlockItem)item).getBlock() : Blocks.AIR;
    }

    public static BlockState pushEntitiesUp(BlockState iblockdata, BlockState iblockdata1, LevelAccessor generatoraccess, BlockPos blockposition) {
        VoxelShape voxelshape = Shapes.joinUnoptimized(iblockdata.getCollisionShape(generatoraccess, blockposition), iblockdata1.getCollisionShape(generatoraccess, blockposition), BooleanOp.ONLY_SECOND).move(blockposition);
        if (voxelshape.isEmpty()) {
            return iblockdata1;
        }
        for (Entity entity : generatoraccess.getEntities(null, voxelshape.bounds())) {
            double d0 = Shapes.collide(Direction.Axis.Y, entity.getBoundingBox().move(0.0, 1.0, 0.0), List.of(voxelshape), -1.0);
            entity.teleportRelative(0.0, 1.0 + d0, 0.0);
        }
        return iblockdata1;
    }

    public static VoxelShape box(double d0, double d1, double d2, double d3, double d4, double d5) {
        return Shapes.box(d0 / 16.0, d1 / 16.0, d2 / 16.0, d3 / 16.0, d4 / 16.0, d5 / 16.0);
    }

    public static VoxelShape[] boxes(int i, IntFunction<VoxelShape> intfunction) {
        return (VoxelShape[])IntStream.rangeClosed(0, i).mapToObj(intfunction).toArray(VoxelShape[]::new);
    }

    public static VoxelShape cube(double d0) {
        return Block.cube(d0, d0, d0);
    }

    public static VoxelShape cube(double d0, double d1, double d2) {
        double d3 = d1 / 2.0;
        return Block.column(d0, d2, 8.0 - d3, 8.0 + d3);
    }

    public static VoxelShape column(double d0, double d1, double d2) {
        return Block.column(d0, d0, d1, d2);
    }

    public static VoxelShape column(double d0, double d1, double d2, double d3) {
        double d4 = d0 / 2.0;
        double d5 = d1 / 2.0;
        return Block.box(8.0 - d4, d2, 8.0 - d5, 8.0 + d4, d3, 8.0 + d5);
    }

    public static VoxelShape boxZ(double d0, double d1, double d2) {
        return Block.boxZ(d0, d0, d1, d2);
    }

    public static VoxelShape boxZ(double d0, double d1, double d2, double d3) {
        double d4 = d1 / 2.0;
        return Block.boxZ(d0, 8.0 - d4, 8.0 + d4, d2, d3);
    }

    public static VoxelShape boxZ(double d0, double d1, double d2, double d3, double d4) {
        double d5 = d0 / 2.0;
        return Block.box(8.0 - d5, d1, d3, 8.0 + d5, d2, d4);
    }

    public static BlockState updateFromNeighbourShapes(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition) {
        BlockState iblockdata1 = iblockdata;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : UPDATE_SHAPE_ORDER) {
            blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection);
            iblockdata1 = iblockdata1.updateShape(generatoraccess, generatoraccess, blockposition, enumdirection, blockposition_mutableblockposition, generatoraccess.getBlockState(blockposition_mutableblockposition), generatoraccess.getRandom());
        }
        return iblockdata1;
    }

    public static void updateOrDestroy(BlockState iblockdata, BlockState iblockdata1, LevelAccessor generatoraccess, BlockPos blockposition, @UpdateFlags int i) {
        Block.updateOrDestroy(iblockdata, iblockdata1, generatoraccess, blockposition, i, 512);
    }

    public static void updateOrDestroy(BlockState iblockdata, BlockState iblockdata1, LevelAccessor generatoraccess, BlockPos blockposition, @UpdateFlags int i, int j) {
        if (iblockdata1 != iblockdata) {
            if (iblockdata1.isAir()) {
                if (!generatoraccess.isClientSide()) {
                    generatoraccess.destroyBlock(blockposition, (i & 0x20) == 0, null, j);
                }
            } else {
                generatoraccess.setBlock(blockposition, iblockdata1, i & 0xFFFFFFDF, j);
            }
        }
    }

    public Block(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        String s;
        StateDefinition.Builder<Block, BlockState> blockstatelist_a = new StateDefinition.Builder<Block, BlockState>(this);
        this.createBlockStateDefinition(blockstatelist_a);
        this.stateDefinition = blockstatelist_a.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState(this.stateDefinition.any());
        if (SharedConstants.IS_RUNNING_IN_IDE && !(s = this.getClass().getSimpleName()).endsWith("Block")) {
            LOGGER.error("Block classes should end with Block and {} doesn't.", (Object)s);
        }
    }

    public static boolean isExceptionForConnection(BlockState iblockdata) {
        return iblockdata.getBlock() instanceof LeavesBlock || iblockdata.is(Blocks.BARRIER) || iblockdata.is(Blocks.CARVED_PUMPKIN) || iblockdata.is(Blocks.JACK_O_LANTERN) || iblockdata.is(Blocks.MELON) || iblockdata.is(Blocks.PUMPKIN) || iblockdata.is(BlockTags.SHULKER_BOXES);
    }

    protected static boolean dropFromBlockInteractLootTable(ServerLevel worldserver, ResourceKey<LootTable> resourcekey, BlockState iblockdata, @Nullable BlockEntity tileentity, @Nullable ItemStack itemstack, @Nullable Entity entity, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        return Block.dropFromLootTable(worldserver, resourcekey, lootparams_a -> lootparams_a.withParameter(LootContextParams.BLOCK_STATE, iblockdata).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity).withOptionalParameter(LootContextParams.INTERACTING_ENTITY, entity).withOptionalParameter(LootContextParams.TOOL, itemstack).create(LootContextParamSets.BLOCK_INTERACT), biconsumer);
    }

    protected static boolean dropFromLootTable(ServerLevel worldserver, ResourceKey<LootTable> resourcekey, Function<LootParams.Builder, LootParams> function, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams = function.apply(new LootParams.Builder(worldserver)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(worldserver, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public static boolean shouldRenderFace(BlockState iblockdata, BlockState iblockdata1, Direction enumdirection) {
        VoxelShape voxelshape = iblockdata1.getFaceOcclusionShape(enumdirection.getOpposite());
        if (voxelshape == Shapes.block()) {
            return false;
        }
        if (iblockdata.skipRendering(iblockdata1, enumdirection)) {
            return false;
        }
        if (voxelshape == Shapes.empty()) {
            return true;
        }
        VoxelShape voxelshape1 = iblockdata.getFaceOcclusionShape(enumdirection);
        if (voxelshape1 == Shapes.empty()) {
            return true;
        }
        ShapePairKey block_a = new ShapePairKey(voxelshape1, voxelshape);
        Object2ByteLinkedOpenHashMap<ShapePairKey> object2bytelinkedopenhashmap = OCCLUSION_CACHE.get();
        byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block_a);
        if (b0 != 127) {
            return b0 != 0;
        }
        boolean flag = Shapes.joinIsNotEmpty(voxelshape1, voxelshape, BooleanOp.ONLY_FIRST);
        if (object2bytelinkedopenhashmap.size() == 256) {
            object2bytelinkedopenhashmap.removeLastByte();
        }
        object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block_a, (byte)(flag ? 1 : 0));
        return flag;
    }

    public static boolean canSupportRigidBlock(BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockaccess.getBlockState(blockposition).isFaceSturdy(iblockaccess, blockposition, Direction.UP, SupportType.RIGID);
    }

    public static boolean canSupportCenter(LevelReader iworldreader, BlockPos blockposition, Direction enumdirection) {
        BlockState iblockdata = iworldreader.getBlockState(blockposition);
        return enumdirection == Direction.DOWN && iblockdata.is(BlockTags.UNSTABLE_BOTTOM_CENTER) ? false : iblockdata.isFaceSturdy(iworldreader, blockposition, enumdirection, SupportType.CENTER);
    }

    public static boolean isFaceFull(VoxelShape voxelshape, Direction enumdirection) {
        VoxelShape voxelshape1 = voxelshape.getFaceShape(enumdirection);
        return Block.isShapeFullBlock(voxelshape1);
    }

    public static boolean isShapeFullBlock(VoxelShape voxelshape) {
        return (Boolean)SHAPE_FULL_BLOCK_CACHE.getUnchecked((Object)voxelshape);
    }

    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
    }

    public void destroy(LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata) {
    }

    public static List<ItemStack> getDrops(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, @Nullable BlockEntity tileentity) {
        LootParams.Builder lootparams_a = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.TOOL, ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity);
        return iblockdata.getDrops(lootparams_a);
    }

    public static List<ItemStack> getDrops(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, @Nullable BlockEntity tileentity, @Nullable Entity entity, ItemStack itemstack) {
        LootParams.Builder lootparams_a = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.TOOL, itemstack).withOptionalParameter(LootContextParams.THIS_ENTITY, entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity);
        return iblockdata.getDrops(lootparams_a);
    }

    public static void dropResources(BlockState iblockdata, Level world, BlockPos blockposition) {
        if (world instanceof ServerLevel) {
            Block.getDrops(iblockdata, (ServerLevel)world, blockposition, null).forEach(itemstack -> Block.popResource(world, blockposition, itemstack));
            iblockdata.spawnAfterBreak((ServerLevel)world, blockposition, ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, @Nullable BlockEntity tileentity) {
        if (generatoraccess instanceof ServerLevel) {
            Block.getDrops(iblockdata, (ServerLevel)generatoraccess, blockposition, tileentity).forEach(itemstack -> Block.popResource((Level)((ServerLevel)generatoraccess), blockposition, itemstack));
            iblockdata.spawnAfterBreak((ServerLevel)generatoraccess, blockposition, ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(BlockState iblockdata, Level world, BlockPos blockposition, @Nullable BlockEntity tileentity, @Nullable Entity entity, ItemStack itemstack) {
        if (world instanceof ServerLevel) {
            Block.getDrops(iblockdata, (ServerLevel)world, blockposition, tileentity, entity, itemstack).forEach(itemstack1 -> Block.popResource(world, blockposition, itemstack1));
            iblockdata.spawnAfterBreak((ServerLevel)world, blockposition, itemstack, true);
        }
    }

    public static void popResource(Level world, BlockPos blockposition, ItemStack itemstack) {
        double d0 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d1 = (double)blockposition.getX() + 0.5 + Mth.nextDouble(world.random, -0.25, 0.25);
        double d2 = (double)blockposition.getY() + 0.5 + Mth.nextDouble(world.random, -0.25, 0.25) - d0;
        double d3 = (double)blockposition.getZ() + 0.5 + Mth.nextDouble(world.random, -0.25, 0.25);
        Block.popResource(world, () -> new ItemEntity(world, d1, d2, d3, itemstack), itemstack);
    }

    public static void popResourceFromFace(Level world, BlockPos blockposition, Direction enumdirection, ItemStack itemstack) {
        int i = enumdirection.getStepX();
        int j = enumdirection.getStepY();
        int k = enumdirection.getStepZ();
        double d0 = (double)EntityType.ITEM.getWidth() / 2.0;
        double d1 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d2 = (double)blockposition.getX() + 0.5 + (i == 0 ? Mth.nextDouble(world.random, -0.25, 0.25) : (double)i * (0.5 + d0));
        double d3 = (double)blockposition.getY() + 0.5 + (j == 0 ? Mth.nextDouble(world.random, -0.25, 0.25) : (double)j * (0.5 + d1)) - d1;
        double d4 = (double)blockposition.getZ() + 0.5 + (k == 0 ? Mth.nextDouble(world.random, -0.25, 0.25) : (double)k * (0.5 + d0));
        double d5 = i == 0 ? Mth.nextDouble(world.random, -0.1, 0.1) : (double)i * 0.1;
        double d6 = j == 0 ? Mth.nextDouble(world.random, 0.0, 0.1) : (double)j * 0.1 + 0.1;
        double d7 = k == 0 ? Mth.nextDouble(world.random, -0.1, 0.1) : (double)k * 0.1;
        Block.popResource(world, () -> new ItemEntity(world, d2, d3, d4, itemstack, d5, d6, d7), itemstack);
    }

    private static void popResource(Level world, Supplier<ItemEntity> supplier, ItemStack itemstack) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!itemstack.isEmpty() && worldserver.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue()) {
                ItemEntity entityitem = supplier.get();
                entityitem.setDefaultPickUpDelay();
                if (world.captureDrops != null) {
                    world.captureDrops.add(entityitem);
                } else {
                    world.addFreshEntity(entityitem);
                }
                return;
            }
        }
    }

    public void popExperience(ServerLevel worldserver, BlockPos blockposition, int i) {
        if (worldserver.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue()) {
            ExperienceOrb.award(worldserver, Vec3.atCenterOf(blockposition), i);
        }
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public void wasExploded(ServerLevel worldserver, BlockPos blockposition, Explosion explosion) {
    }

    public void stepOn(Level world, BlockPos blockposition, BlockState iblockdata, Entity entity) {
    }

    public @Nullable BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return this.defaultBlockState();
    }

    public void playerDestroy(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata, @Nullable BlockEntity tileentity, ItemStack itemstack) {
        entityhuman.awardStat(Stats.BLOCK_MINED.get(this));
        entityhuman.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        Block.dropResources(iblockdata, world, blockposition, tileentity, entityhuman, itemstack);
    }

    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
    }

    public boolean isPossibleToRespawnInThis(BlockState iblockdata) {
        return !iblockdata.isSolid() && !iblockdata.liquid();
    }

    public MutableComponent getName() {
        return Component.translatable(this.getDescriptionId());
    }

    public void fallOn(Level world, BlockState iblockdata, BlockPos blockposition, Entity entity, double d0) {
        entity.causeFallDamage(d0, 1.0f, entity.damageSources().fall());
    }

    public void updateEntityMovementAfterFallOn(BlockGetter iblockaccess, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    public float getFriction() {
        return this.friction;
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    public float getJumpFactor() {
        return this.jumpFactor;
    }

    protected void spawnDestroyParticles(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata) {
        world.levelEvent(entityhuman, 2001, blockposition, Block.getId(iblockdata));
    }

    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        this.spawnDestroyParticles(world, entityhuman, blockposition, iblockdata);
        if (iblockdata.is(BlockTags.GUARDED_BY_PIGLINS) && world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            PiglinAi.angerNearbyPiglins(worldserver, entityhuman, false);
        }
        world.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.Context.of(entityhuman, iblockdata));
        return iblockdata;
    }

    public void handlePrecipitation(BlockState iblockdata, Level world, BlockPos blockposition, Biome.Precipitation biomebase_precipitation) {
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.stateDefinition;
    }

    protected final void registerDefaultState(BlockState iblockdata) {
        this.defaultBlockState = iblockdata;
    }

    public final BlockState defaultBlockState() {
        return this.defaultBlockState;
    }

    public final BlockState withPropertiesOf(BlockState iblockdata) {
        BlockState iblockdata1 = this.defaultBlockState();
        for (Property<?> iblockstate : iblockdata.getBlock().getStateDefinition().getProperties()) {
            if (!iblockdata1.hasProperty(iblockstate)) continue;
            iblockdata1 = Block.copyProperty(iblockdata, iblockdata1, iblockstate);
        }
        return iblockdata1;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState iblockdata, BlockState iblockdata1, Property<T> iblockstate) {
        return (BlockState)iblockdata1.setValue(iblockstate, iblockdata.getValue(iblockstate));
    }

    @Override
    public Item asItem() {
        if (this.item == null) {
            this.item = Item.byBlock(this);
        }
        return this.item;
    }

    public boolean hasDynamicShape() {
        return this.dynamicShape;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.BLOCK.wrapAsHolder(this).getRegisteredName() + "}";
    }

    @Override
    protected Block asBlock() {
        return this;
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> function) {
        ImmutableMap immutablemap = (ImmutableMap)this.stateDefinition.getPossibleStates().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), function));
        Objects.requireNonNull(immutablemap);
        return arg_0 -> ((ImmutableMap)immutablemap).get(arg_0);
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> function, Property<?> ... aiblockstate) {
        Map<Property, Comparable> map = Arrays.stream(aiblockstate).collect(Collectors.toMap(iblockstate -> iblockstate, iblockstate -> (Comparable)iblockstate.getPossibleValues().getFirst()));
        ImmutableMap immutablemap = (ImmutableMap)this.stateDefinition.getPossibleStates().stream().filter(iblockdata -> map.entrySet().stream().allMatch(entry -> iblockdata.getValue((Property)entry.getKey()) == entry.getValue())).collect(ImmutableMap.toImmutableMap(Function.identity(), function));
        return iblockdata -> {
            for (Map.Entry map_entry : map.entrySet()) {
                iblockdata = Block.setValueHelper(iblockdata, (Property)map_entry.getKey(), map_entry.getValue());
            }
            return (VoxelShape)immutablemap.get(iblockdata);
        };
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S s0, Property<T> iblockstate, Object object) {
        return (S)((StateHolder)s0.setValue(iblockstate, (Comparable)((Comparable)object)));
    }

    @Deprecated
    public Holder.Reference<Block> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    protected int tryDropExperience(ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, IntProvider intprovider) {
        int i = EnchantmentHelper.processBlockExperience(worldserver, itemstack, intprovider.sample(worldserver.getRandom()));
        if (i > 0) {
            return i;
        }
        return 0;
    }

    public int getExpDrop(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        return 0;
    }

    public static float range(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private record ShapePairKey(VoxelShape first, VoxelShape second) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof ShapePairKey) {
                ShapePairKey block_a = (ShapePairKey)object;
                if (this.first == block_a.first && this.second == block_a.second) {
                    boolean flag = true;
                    return flag;
                }
            }
            boolean flag = false;
            return flag;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.first) * 31 + System.identityHashCode(this.second);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.TYPE_USE})
    public static @interface UpdateFlags {
    }
}

