/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class CampfireBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<CampfireBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(blockcampfire -> blockcampfire.spawnParticles), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(blockcampfire -> blockcampfire.fireDamage), CampfireBlock.propertiesCodec()).apply((Applicative)instance, CampfireBlock::new));
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.SIGNAL_FIRE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 7.0);
    private static final VoxelShape SHAPE_VIRTUAL_POST = Block.column(4.0, 0.0, 16.0);
    private static final int SMOKE_DISTANCE = 5;
    private final boolean spawnParticles;
    private final int fireDamage;

    public MapCodec<CampfireBlock> codec() {
        return CODEC;
    }

    public CampfireBlock(boolean flag, int i, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.spawnParticles = flag;
        this.fireDamage = i;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(LIT, true)).setValue(SIGNAL_FIRE, false)).setValue(WATERLOGGED, false)).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof CampfireBlockEntity) {
            CampfireBlockEntity tileentitycampfire = (CampfireBlockEntity)tileentity;
            ItemStack itemstack1 = entityhuman.getItemInHand(enumhand);
            if (world.recipeAccess().propertySet(RecipePropertySet.CAMPFIRE_INPUT).test(itemstack1)) {
                ServerLevel worldserver;
                if (world instanceof ServerLevel && tileentitycampfire.placeFood(worldserver = (ServerLevel)world, entityhuman, itemstack1)) {
                    entityhuman.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (iblockdata.getValue(LIT).booleanValue() && entity instanceof LivingEntity) {
            entity.hurt(world.damageSources().campfire().directBlock(world, blockposition), this.fireDamage);
        }
        super.entityInside(iblockdata, world, blockposition, entity, insideblockeffectapplier, flag);
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockPos blockposition;
        Level generatoraccess = blockactioncontext.getLevel();
        boolean flag = generatoraccess.getFluidState(blockposition = blockactioncontext.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(WATERLOGGED, flag)).setValue(SIGNAL_FIRE, this.isSmokeSource(generatoraccess.getBlockState(blockposition.below())))).setValue(LIT, !flag)).setValue(FACING, blockactioncontext.getHorizontalDirection());
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        return enumdirection == Direction.DOWN ? (BlockState)iblockdata.setValue(SIGNAL_FIRE, this.isSmokeSource(iblockdata1)) : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private boolean isSmokeSource(BlockState iblockdata) {
        return iblockdata.is(Blocks.HAY_BLOCK);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            if (randomsource.nextInt(10) == 0) {
                world.playLocalSound((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + randomsource.nextFloat(), randomsource.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.spawnParticles && randomsource.nextInt(5) == 0) {
                for (int i = 0; i < randomsource.nextInt(1) + 1; ++i) {
                    world.addParticle(ParticleTypes.LAVA, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, randomsource.nextFloat() / 2.0f, 5.0E-5, randomsource.nextFloat() / 2.0f);
                }
            }
        }
    }

    public static void dowse(@Nullable Entity entity, LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata) {
        if (generatoraccess.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                CampfireBlock.makeParticles((Level)generatoraccess, blockposition, iblockdata.getValue(SIGNAL_FIRE), true);
            }
        }
        generatoraccess.gameEvent(entity, GameEvent.BLOCK_CHANGE, blockposition);
    }

    @Override
    public boolean placeLiquid(LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata, FluidState fluid) {
        if (!iblockdata.getValue(BlockStateProperties.WATERLOGGED).booleanValue() && fluid.getType() == Fluids.WATER) {
            boolean flag = iblockdata.getValue(LIT);
            if (flag) {
                if (!generatoraccess.isClientSide()) {
                    generatoraccess.playSound(null, blockposition, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                CampfireBlock.dowse(null, generatoraccess, blockposition, iblockdata);
            }
            generatoraccess.setBlock(blockposition, (BlockState)((BlockState)iblockdata.setValue(WATERLOGGED, true)).setValue(LIT, false), 3);
            generatoraccess.scheduleTick(blockposition, fluid.getType(), fluid.getType().getTickDelay(generatoraccess));
            return true;
        }
        return false;
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (iprojectile.isOnFire() && iprojectile.mayInteract(worldserver, blockposition) && !iblockdata.getValue(LIT).booleanValue() && !iblockdata.getValue(WATERLOGGED).booleanValue()) {
                if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, iprojectile).isCancelled()) {
                    return;
                }
                world.setBlock(blockposition, (BlockState)iblockdata.setValue(BlockStateProperties.LIT, true), 11);
            }
        }
    }

    public static void makeParticles(Level world, BlockPos blockposition, boolean flag, boolean flag1) {
        RandomSource randomsource = world.getRandom();
        SimpleParticleType particletype = flag ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
        world.addAlwaysVisibleParticle(particletype, true, (double)blockposition.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)blockposition.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)blockposition.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (flag1) {
            world.addParticle(ParticleTypes.SMOKE, (double)blockposition.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)blockposition.getY() + 0.4, (double)blockposition.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isSmokeyPos(Level world, BlockPos blockposition) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos blockposition1 = blockposition.below(i);
            BlockState iblockdata = world.getBlockState(blockposition1);
            if (CampfireBlock.isLitCampfire(iblockdata)) {
                return true;
            }
            boolean flag = Shapes.joinIsNotEmpty(SHAPE_VIRTUAL_POST, iblockdata.getCollisionShape(world, blockposition, CollisionContext.empty()), BooleanOp.AND);
            if (!flag) continue;
            BlockState iblockdata1 = world.getBlockState(blockposition1.below());
            return CampfireBlock.isLitCampfire(iblockdata1);
        }
        return false;
    }

    public static boolean isLitCampfire(BlockState iblockdata) {
        return iblockdata.hasProperty(LIT) && iblockdata.is(BlockTags.CAMPFIRES) && iblockdata.getValue(LIT) != false;
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(LIT, SIGNAL_FIRE, WATERLOGGED, FACING);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new CampfireBlockEntity(blockposition, iblockdata);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (iblockdata.getValue(LIT).booleanValue()) {
                RecipeManager.CachedCheck craftingmanager_a = RecipeManager.createCheck(RecipeType.CAMPFIRE_COOKING);
                return CampfireBlock.createTickerHelper(tileentitytypes, BlockEntityType.CAMPFIRE, (world1, blockposition, iblockdata1, tileentitycampfire) -> CampfireBlockEntity.cookTick(worldserver, blockposition, iblockdata1, tileentitycampfire, craftingmanager_a));
            }
            return CampfireBlock.createTickerHelper(tileentitytypes, BlockEntityType.CAMPFIRE, CampfireBlockEntity::cooldownTick);
        }
        return iblockdata.getValue(LIT) != false ? CampfireBlock.createTickerHelper(tileentitytypes, BlockEntityType.CAMPFIRE, CampfireBlockEntity::particleTick) : null;
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    public static boolean canLight(BlockState iblockdata) {
        return iblockdata.is(BlockTags.CAMPFIRES, blockbase_blockdata -> blockbase_blockdata.hasProperty(WATERLOGGED) && blockbase_blockdata.hasProperty(LIT)) && iblockdata.getValue(WATERLOGGED) == false && iblockdata.getValue(LIT) == false;
    }
}

