/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<CandleBlock> CODEC = CandleBlock.simpleCodec(CandleBlock::new);
    public static final int MIN_CANDLES = 1;
    public static final int MAX_CANDLES = 4;
    public static final IntegerProperty CANDLES = BlockStateProperties.CANDLES;
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = var0 -> var0.getValue(LIT) != false ? 3 * var0.getValue(CANDLES) : 0;
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.make(new Int2ObjectOpenHashMap(4), var0 -> {
        float var1 = 0.0625f;
        var0.put(1, List.of(new Vec3(8.0, 8.0, 8.0).scale(0.0625)));
        var0.put(2, List.of(new Vec3(6.0, 7.0, 8.0).scale(0.0625), new Vec3(10.0, 8.0, 7.0).scale(0.0625)));
        var0.put(3, List.of(new Vec3(8.0, 5.0, 10.0).scale(0.0625), new Vec3(6.0, 7.0, 8.0).scale(0.0625), new Vec3(9.0, 8.0, 7.0).scale(0.0625)));
        var0.put(4, List.of(new Vec3(7.0, 5.0, 9.0).scale(0.0625), new Vec3(10.0, 7.0, 9.0).scale(0.0625), new Vec3(6.0, 7.0, 6.0).scale(0.0625), new Vec3(9.0, 8.0, 6.0).scale(0.0625)));
    });
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.column(2.0, 0.0, 6.0), Block.box(5.0, 0.0, 6.0, 11.0, 6.0, 9.0), Block.box(5.0, 0.0, 6.0, 10.0, 6.0, 11.0), Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 10.0)};

    public MapCodec<CandleBlock> codec() {
        return CODEC;
    }

    public CandleBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(CANDLES, 1)).setValue(LIT, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        if (var0.isEmpty() && var4.getAbilities().mayBuild && var1.getValue(LIT).booleanValue()) {
            CandleBlock.extinguish(var4, var1, var2, var3);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().getItem() == this.asItem() && var0.getValue(CANDLES) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        BlockState var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (BlockState)var1.cycle(CANDLES);
        }
        FluidState var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var3 = var2.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(var0).setValue(WATERLOGGED, var3);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPES[var0.getValue(CANDLES) - 1];
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(CANDLES, LIT, WATERLOGGED);
    }

    @Override
    public boolean placeLiquid(LevelAccessor var0, BlockPos var1, BlockState var2, FluidState var3) {
        if (var2.getValue(WATERLOGGED).booleanValue() || var3.getType() != Fluids.WATER) {
            return false;
        }
        BlockState var4 = (BlockState)var2.setValue(WATERLOGGED, true);
        if (var2.getValue(LIT).booleanValue()) {
            CandleBlock.extinguish(null, var4, var0, var1);
        } else {
            var0.setBlock(var1, var4, 3);
        }
        var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
        return true;
    }

    public static boolean canLight(BlockState var02) {
        return var02.is(BlockTags.CANDLES, var0 -> var0.hasProperty(LIT) && var0.hasProperty(WATERLOGGED)) && var02.getValue(LIT) == false && var02.getValue(WATERLOGGED) == false;
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState var0) {
        return (Iterable)PARTICLE_OFFSETS.get(var0.getValue(CANDLES).intValue());
    }

    @Override
    protected boolean canBeLit(BlockState var0) {
        return var0.getValue(WATERLOGGED) == false && super.canBeLit(var0);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return Block.canSupportCenter(var1, var2.below(), Direction.UP);
    }
}

