/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.golem.CopperGolem;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CopperChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class CarvedPumpkinBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<CarvedPumpkinBlock> CODEC = CarvedPumpkinBlock.simpleCodec(CarvedPumpkinBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private @Nullable BlockPattern snowGolemBase;
    private @Nullable BlockPattern snowGolemFull;
    private @Nullable BlockPattern ironGolemBase;
    private @Nullable BlockPattern ironGolemFull;
    private @Nullable BlockPattern copperGolemBase;
    private @Nullable BlockPattern copperGolemFull;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = iblockdata -> iblockdata.is(Blocks.CARVED_PUMPKIN) || iblockdata.is(Blocks.JACK_O_LANTERN);

    public MapCodec<? extends CarvedPumpkinBlock> codec() {
        return CODEC;
    }

    protected CarvedPumpkinBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            this.trySpawnGolem(world, blockposition);
        }
    }

    public boolean canSpawnGolem(LevelReader iworldreader, BlockPos blockposition) {
        return this.getOrCreateSnowGolemBase().find(iworldreader, blockposition) != null || this.getOrCreateIronGolemBase().find(iworldreader, blockposition) != null || this.getOrCreateCopperGolemBase().find(iworldreader, blockposition) != null;
    }

    private void trySpawnGolem(Level world, BlockPos blockposition) {
        CopperGolem coppergolem;
        IronGolem entityirongolem;
        SnowGolem entitysnowman;
        BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection = this.getOrCreateSnowGolemFull().find(world, blockposition);
        if (shapedetector_shapedetectorcollection != null && (entitysnowman = EntityType.SNOW_GOLEM.create(world, EntitySpawnReason.TRIGGERED)) != null) {
            CarvedPumpkinBlock.spawnGolemInWorld(world, shapedetector_shapedetectorcollection, entitysnowman, shapedetector_shapedetectorcollection.getBlock(0, 2, 0).getPos());
            return;
        }
        BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection1 = this.getOrCreateIronGolemFull().find(world, blockposition);
        if (shapedetector_shapedetectorcollection1 != null && (entityirongolem = EntityType.IRON_GOLEM.create(world, EntitySpawnReason.TRIGGERED)) != null) {
            entityirongolem.setPlayerCreated(true);
            CarvedPumpkinBlock.spawnGolemInWorld(world, shapedetector_shapedetectorcollection1, entityirongolem, shapedetector_shapedetectorcollection1.getBlock(1, 2, 0).getPos());
            return;
        }
        BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection2 = this.getOrCreateCopperGolemFull().find(world, blockposition);
        if (shapedetector_shapedetectorcollection2 != null && (coppergolem = EntityType.COPPER_GOLEM.create(world, EntitySpawnReason.TRIGGERED)) != null) {
            if (!CarvedPumpkinBlock.spawnGolemInWorld(world, shapedetector_shapedetectorcollection2, coppergolem, shapedetector_shapedetectorcollection2.getBlock(0, 0, 0).getPos())) {
                return;
            }
            this.replaceCopperBlockWithChest(world, shapedetector_shapedetectorcollection2);
            coppergolem.spawn(this.getWeatherStateFromPattern(shapedetector_shapedetectorcollection2));
        }
    }

    private WeatheringCopper.WeatherState getWeatherStateFromPattern(BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection) {
        BlockState iblockdata = shapedetector_shapedetectorcollection.getBlock(0, 1, 0).getState();
        Block block = iblockdata.getBlock();
        if (block instanceof WeatheringCopper) {
            WeatheringCopper weatheringcopper = (WeatheringCopper)((Object)block);
            return (WeatheringCopper.WeatherState)weatheringcopper.getAge();
        }
        return (WeatheringCopper.WeatherState)Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)iblockdata.getBlock())).filter(block1 -> block1 instanceof WeatheringCopper).map(block1 -> (WeatheringCopper)((Object)block1)).orElse((WeatheringCopper)((Object)Blocks.COPPER_BLOCK)).getAge();
    }

    private static boolean spawnGolemInWorld(Level world, BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection, Entity entity, BlockPos blockposition) {
        entity.snapTo((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.05, (double)blockposition.getZ() + 0.5, 0.0f, 0.0f);
        if (!world.addFreshEntity(entity, entity.getType() == EntityType.SNOW_GOLEM ? CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN : (entity.getType() == EntityType.IRON_GOLEM ? CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM : CreatureSpawnEvent.SpawnReason.BUILD_COPPERGOLEM))) {
            return false;
        }
        CarvedPumpkinBlock.clearPatternBlocks(world, shapedetector_shapedetectorcollection);
        for (ServerPlayer entityplayer : world.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(entityplayer, entity);
        }
        CarvedPumpkinBlock.updatePatternBlocks(world, shapedetector_shapedetectorcollection);
        return true;
    }

    public static void clearPatternBlocks(Level world, BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection) {
        for (int i = 0; i < shapedetector_shapedetectorcollection.getWidth(); ++i) {
            for (int j = 0; j < shapedetector_shapedetectorcollection.getHeight(); ++j) {
                BlockInWorld shapedetectorblock = shapedetector_shapedetectorcollection.getBlock(i, j, 0);
                world.setBlock(shapedetectorblock.getPos(), Blocks.AIR.defaultBlockState(), 2);
                world.levelEvent(2001, shapedetectorblock.getPos(), Block.getId(shapedetectorblock.getState()));
            }
        }
    }

    public static void updatePatternBlocks(Level world, BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection) {
        for (int i = 0; i < shapedetector_shapedetectorcollection.getWidth(); ++i) {
            for (int j = 0; j < shapedetector_shapedetectorcollection.getHeight(); ++j) {
                BlockInWorld shapedetectorblock = shapedetector_shapedetectorcollection.getBlock(i, j, 0);
                world.updateNeighborsAt(shapedetectorblock.getPos(), Blocks.AIR);
            }
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING);
    }

    private BlockPattern getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = BlockPatternBuilder.start().aisle(" ", "#", "#").where('#', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemBase;
    }

    private BlockPattern getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = BlockPatternBuilder.start().aisle("^", "#", "#").where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemFull;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.start().aisle("~ ~", "###", "~#~").where('#', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.IRON_BLOCK))).where('~', BlockInWorld.hasState(BlockBehaviour.BlockStateBase::isAir)).build();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.start().aisle("~^~", "###", "~#~").where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.IRON_BLOCK))).where('~', BlockInWorld.hasState(BlockBehaviour.BlockStateBase::isAir)).build();
        }
        return this.ironGolemFull;
    }

    private BlockPattern getOrCreateCopperGolemBase() {
        if (this.copperGolemBase == null) {
            this.copperGolemBase = BlockPatternBuilder.start().aisle(" ", "#").where('#', BlockInWorld.hasState(iblockdata -> iblockdata.is(BlockTags.COPPER))).build();
        }
        return this.copperGolemBase;
    }

    private BlockPattern getOrCreateCopperGolemFull() {
        if (this.copperGolemFull == null) {
            this.copperGolemFull = BlockPatternBuilder.start().aisle("^", "#").where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState(iblockdata -> iblockdata.is(BlockTags.COPPER))).build();
        }
        return this.copperGolemFull;
    }

    public void replaceCopperBlockWithChest(Level world, BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection) {
        BlockInWorld shapedetectorblock = shapedetector_shapedetectorcollection.getBlock(0, 1, 0);
        BlockInWorld shapedetectorblock1 = shapedetector_shapedetectorcollection.getBlock(0, 0, 0);
        Direction enumdirection = shapedetectorblock1.getState().getValue(FACING);
        BlockState iblockdata = CopperChestBlock.getFromCopperBlock(shapedetectorblock.getState().getBlock(), enumdirection, world, shapedetectorblock.getPos());
        world.setBlock(shapedetectorblock.getPos(), iblockdata, 2);
    }
}

