/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class ChorusPlantBlock
extends PipeBlock {
    public static final MapCodec<ChorusPlantBlock> CODEC = ChorusPlantBlock.simpleCodec(ChorusPlantBlock::new);

    public MapCodec<ChorusPlantBlock> codec() {
        return CODEC;
    }

    protected ChorusPlantBlock(BlockBehaviour.Properties var0) {
        super(10.0f, var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false)).setValue(DOWN, false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return ChorusPlantBlock.getStateWithConnections(var0.getLevel(), var0.getClickedPos(), this.defaultBlockState());
    }

    public static BlockState getStateWithConnections(BlockGetter var0, BlockPos var1, BlockState var2) {
        BlockState var3 = var0.getBlockState(var1.below());
        BlockState var4 = var0.getBlockState(var1.above());
        BlockState var5 = var0.getBlockState(var1.north());
        BlockState var6 = var0.getBlockState(var1.east());
        BlockState var7 = var0.getBlockState(var1.south());
        BlockState var8 = var0.getBlockState(var1.west());
        Block var9 = var2.getBlock();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)var2.trySetValue(DOWN, var3.is(var9) || var3.is(Blocks.CHORUS_FLOWER) || var3.is(Blocks.END_STONE))).trySetValue(UP, var4.is(var9) || var4.is(Blocks.CHORUS_FLOWER))).trySetValue(NORTH, var5.is(var9) || var5.is(Blocks.CHORUS_FLOWER))).trySetValue(EAST, var6.is(var9) || var6.is(Blocks.CHORUS_FLOWER))).trySetValue(SOUTH, var7.is(var9) || var7.is(Blocks.CHORUS_FLOWER))).trySetValue(WEST, var8.is(var9) || var8.is(Blocks.CHORUS_FLOWER));
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (!var0.canSurvive(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        boolean var8 = var6.is(this) || var6.is(Blocks.CHORUS_FLOWER) || var4 == Direction.DOWN && var6.is(Blocks.END_STONE);
        return (BlockState)var0.setValue((Property)PROPERTY_BY_DIRECTION.get(var4), var8);
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockState var3 = var1.getBlockState(var2.below());
        boolean var4 = !var1.getBlockState(var2.above()).isAir() && !var3.isAir();
        for (Direction var6 : Direction.Plane.HORIZONTAL) {
            BlockPos var7 = var2.relative(var6);
            BlockState var8 = var1.getBlockState(var7);
            if (!var8.is(this)) continue;
            if (var4) {
                return false;
            }
            BlockState var9 = var1.getBlockState(var7.below());
            if (!var9.is(this) && !var9.is(Blocks.END_STONE)) continue;
            return true;
        }
        return var3.is(this) || var3.is(Blocks.END_STONE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

