/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;

public class CopperChestBlock
extends ChestBlock {
    public static final MapCodec<CopperChestBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)WeatheringCopper.WeatherState.CODEC.fieldOf("weathering_state").forGetter(CopperChestBlock::getState), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("open_sound").forGetter(ChestBlock::getOpenChestSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("close_sound").forGetter(ChestBlock::getCloseChestSound), CopperChestBlock.propertiesCodec()).apply((Applicative)var0, CopperChestBlock::new));
    private static final Map<Block, Supplier<Block>> COPPER_TO_COPPER_CHEST_MAPPING = Map.of(Blocks.COPPER_BLOCK, () -> Blocks.COPPER_CHEST, Blocks.EXPOSED_COPPER, () -> Blocks.EXPOSED_COPPER_CHEST, Blocks.WEATHERED_COPPER, () -> Blocks.WEATHERED_COPPER_CHEST, Blocks.OXIDIZED_COPPER, () -> Blocks.OXIDIZED_COPPER_CHEST, Blocks.WAXED_COPPER_BLOCK, () -> Blocks.COPPER_CHEST, Blocks.WAXED_EXPOSED_COPPER, () -> Blocks.EXPOSED_COPPER_CHEST, Blocks.WAXED_WEATHERED_COPPER, () -> Blocks.WEATHERED_COPPER_CHEST, Blocks.WAXED_OXIDIZED_COPPER, () -> Blocks.OXIDIZED_COPPER_CHEST);
    private final WeatheringCopper.WeatherState weatherState;

    @Override
    public MapCodec<? extends CopperChestBlock> codec() {
        return CODEC;
    }

    public CopperChestBlock(WeatheringCopper.WeatherState var0, SoundEvent var1, SoundEvent var2, BlockBehaviour.Properties var3) {
        super(() -> BlockEntityType.CHEST, var1, var2, var3);
        this.weatherState = var0;
    }

    @Override
    public boolean chestCanConnectTo(BlockState var0) {
        return var0.is(BlockTags.COPPER_CHESTS) && var0.hasProperty(ChestBlock.TYPE);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        BlockState var1 = super.getStateForPlacement(var0);
        return CopperChestBlock.getLeastOxidizedChestOfConnectedBlocks(var1, var0.getLevel(), var0.getClickedPos());
    }

    private static BlockState getLeastOxidizedChestOfConnectedBlocks(BlockState var0, Level var1, BlockPos var2) {
        Block block;
        BlockState var3 = var1.getBlockState(var2.relative(CopperChestBlock.getConnectedDirection(var0)));
        if (!var0.getValue(ChestBlock.TYPE).equals(ChestType.SINGLE) && (block = var0.getBlock()) instanceof CopperChestBlock) {
            CopperChestBlock var4 = (CopperChestBlock)block;
            block = var3.getBlock();
            if (block instanceof CopperChestBlock) {
                CopperChestBlock var5 = (CopperChestBlock)block;
                BlockState var6 = var0;
                BlockState var7 = var3;
                if (var4.isWaxed() != var5.isWaxed()) {
                    var6 = CopperChestBlock.unwaxBlock(var4, var0).orElse(var6);
                    var7 = CopperChestBlock.unwaxBlock(var5, var3).orElse(var7);
                }
                Block var8 = var4.weatherState.ordinal() <= var5.weatherState.ordinal() ? var6.getBlock() : var7.getBlock();
                return var8.withPropertiesOf(var6);
            }
        }
        return var0;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        ChestType var9;
        BlockState var8 = super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        if (this.chestCanConnectTo(var6) && !(var9 = var8.getValue(ChestBlock.TYPE)).equals(ChestType.SINGLE) && CopperChestBlock.getConnectedDirection(var8) == var4) {
            return var6.getBlock().withPropertiesOf(var8);
        }
        return var8;
    }

    private static Optional<BlockState> unwaxBlock(CopperChestBlock var0, BlockState var12) {
        if (!var0.isWaxed()) {
            return Optional.of(var12);
        }
        return Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)var12.getBlock())).map(var1 -> var1.withPropertiesOf(var12));
    }

    public WeatheringCopper.WeatherState getState() {
        return this.weatherState;
    }

    public static BlockState getFromCopperBlock(Block var0, Direction var1, Level var2, BlockPos var3) {
        CopperChestBlock var4 = (CopperChestBlock)COPPER_TO_COPPER_CHEST_MAPPING.getOrDefault(var0, Blocks.COPPER_CHEST::asBlock).get();
        ChestType var5 = var4.getChestType(var2, var3, var1);
        BlockState var6 = (BlockState)((BlockState)var4.defaultBlockState().setValue(FACING, var1)).setValue(TYPE, var5);
        return CopperChestBlock.getLeastOxidizedChestOfConnectedBlocks(var6, var2, var3);
    }

    public boolean isWaxed() {
        return true;
    }

    @Override
    public boolean shouldChangedStateKeepBlockEntity(BlockState var0) {
        return var0.is(BlockTags.COPPER_CHESTS);
    }
}

