/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jspecify.annotations.Nullable;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<CreakingHeartState> STATE = BlockStateProperties.CREAKING_HEART_STATE;
    public static final BooleanProperty NATURAL = BlockStateProperties.NATURAL;

    public MapCodec<CreakingHeartBlock> codec() {
        return CODEC;
    }

    protected CreakingHeartBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, Direction.Axis.Y)).setValue(STATE, CreakingHeartState.UPROOTED)).setValue(NATURAL, false));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new CreakingHeartBlockEntity(var0, var1);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        if (var0.isClientSide()) {
            return null;
        }
        if (var1.getValue(STATE) != CreakingHeartState.UPROOTED) {
            return CreakingHeartBlock.createTickerHelper(var2, BlockEntityType.CREAKING_HEART, CreakingHeartBlockEntity::serverTick);
        }
        return null;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        if (!var1.environmentAttributes().getValue(EnvironmentAttributes.CREAKING_ACTIVE, var2).booleanValue()) {
            return;
        }
        if (var0.getValue(STATE) == CreakingHeartState.UPROOTED) {
            return;
        }
        if (var3.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs(var1, var2)) {
            var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEvents.CREAKING_HEART_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        var2.scheduleTick(var3, this, 1);
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        BlockState var4 = CreakingHeartBlock.updateState(var0, var1, var2);
        if (var4 != var0) {
            var1.setBlock(var2, var4, 3);
        }
    }

    private static BlockState updateState(BlockState var0, Level var1, BlockPos var2) {
        boolean var4;
        boolean var3 = CreakingHeartBlock.hasRequiredLogs(var0, var1, var2);
        boolean bl = var4 = var0.getValue(STATE) == CreakingHeartState.UPROOTED;
        if (var3 && var4) {
            return (BlockState)var0.setValue(STATE, var1.environmentAttributes().getValue(EnvironmentAttributes.CREAKING_ACTIVE, var2) != false ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT);
        }
        return var0;
    }

    public static boolean hasRequiredLogs(BlockState var0, LevelReader var1, BlockPos var2) {
        Direction.Axis var3 = var0.getValue(AXIS);
        for (Direction var7 : var3.getDirections()) {
            BlockState var8 = var1.getBlockState(var2.relative(var7));
            if (var8.is(BlockTags.PALE_OAK_LOGS) && var8.getValue(AXIS) == var3) continue;
            return false;
        }
        return true;
    }

    private static boolean isSurroundedByLogs(LevelAccessor var0, BlockPos var1) {
        for (Direction var5 : Direction.values()) {
            BlockPos var6 = var1.relative(var5);
            BlockState var7 = var0.getBlockState(var6);
            if (var7.is(BlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        return CreakingHeartBlock.updateState((BlockState)this.defaultBlockState().setValue(AXIS, var0.getClickedFace().getAxis()), var0.getLevel(), var0.getClickedPos());
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return RotatedPillarBlock.rotatePillar(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(AXIS, STATE, NATURAL);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        Containers.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected void onExplosionHit(BlockState var0, ServerLevel var1, BlockPos var2, Explosion var3, BiConsumer<ItemStack, BlockPos> var4) {
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity var5 = (CreakingHeartBlockEntity)blockEntity;
            if (var3 instanceof ServerExplosion) {
                ServerExplosion var6 = (ServerExplosion)var3;
                if (var3.getBlockInteraction().shouldAffectBlocklikeEntities()) {
                    var5.removeProtector(var6.getDamageSource());
                    LivingEntity livingEntity = var3.getIndirectSourceEntity();
                    if (livingEntity instanceof Player) {
                        Player var7 = (Player)livingEntity;
                        if (var3.getBlockInteraction().shouldAffectBlocklikeEntities()) {
                            this.tryAwardExperience(var7, var0, var1, var2);
                        }
                    }
                }
            }
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    @Override
    public BlockState playerWillDestroy(Level var0, BlockPos var1, BlockState var2, Player var3) {
        BlockEntity blockEntity = var0.getBlockEntity(var1);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity var4 = (CreakingHeartBlockEntity)blockEntity;
            var4.removeProtector(var3.damageSources().playerAttack(var3));
            this.tryAwardExperience(var3, var2, var0, var1);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    private void tryAwardExperience(Player var0, BlockState var1, Level var2, BlockPos var3) {
        if (!var0.preventsBlockDrops() && !var0.isSpectator() && var1.getValue(NATURAL).booleanValue() && var2 instanceof ServerLevel) {
            ServerLevel var4 = (ServerLevel)var2;
            this.popExperience(var4, var3, var2.random.nextIntBetweenInclusive(20, 24));
        }
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        if (var0.getValue(STATE) == CreakingHeartState.UPROOTED) {
            return 0;
        }
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (!(blockEntity instanceof CreakingHeartBlockEntity)) {
            return 0;
        }
        CreakingHeartBlockEntity var4 = (CreakingHeartBlockEntity)blockEntity;
        return var4.getAnalogOutputSignal();
    }
}

